/*
 * Decompiled with CFR 0.152.
 */
package com.alphactx;

import com.alphactx.MinecraftHouses;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class HousesPlaceholder
extends PlaceholderExpansion {
    private final MinecraftHouses plugin;

    public HousesPlaceholder(MinecraftHouses plugin) {
        this.plugin = plugin;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String getIdentifier() {
        return "houses";
    }

    public String getAuthor() {
        return String.join((CharSequence)",", this.plugin.getDescription().getAuthors());
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        if (player == null) {
            return "";
        }
        if (identifier.equalsIgnoreCase("owned")) {
            return String.valueOf(this.countOwned(player));
        }
        if (identifier.equalsIgnoreCase("limit")) {
            return String.valueOf(this.plugin.getConfig().getInt("max-houses-per-player", 0));
        }
        if (identifier.equalsIgnoreCase("renting")) {
            return String.valueOf(this.countRenting(player));
        }
        return null;
    }

    private int countOwned(Player p) {
        int owned = 0;
        FileConfiguration cfg = this.plugin.getHousesConfig();
        if (cfg.isConfigurationSection("houses")) {
            for (String id : cfg.getConfigurationSection("houses").getKeys(false)) {
                String owner = cfg.getString("houses." + id + ".owner");
                if (owner == null || !owner.equals(p.getUniqueId().toString())) continue;
                ++owned;
            }
        }
        return owned;
    }

    private int countRenting(Player p) {
        int renting = 0;
        FileConfiguration cfg = this.plugin.getHousesConfig();
        if (cfg.isConfigurationSection("houses")) {
            for (String id : cfg.getConfigurationSection("houses").getKeys(false)) {
                String path = "houses." + id;
                String owner = cfg.getString(path + ".owner");
                if (owner == null || !owner.equals(p.getUniqueId().toString()) || !cfg.getBoolean(path + ".rent")) continue;
                ++renting;
            }
        }
        return renting;
    }
}

