/*
 * Decompiled with CFR 0.152.
 */
package com.alphactx;

import com.alphactx.HousesCommand;
import com.alphactx.HousesPlaceholder;
import com.alphactx.shaded.org.bstats.bukkit.Metrics;
import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.POIMarker;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class MinecraftHouses
extends JavaPlugin
implements Listener {
    private Economy economy;
    private FileConfiguration housesConfig;
    private Connection sqlConnection;
    private boolean sqlDebug;
    private int autoSaveTask = -1;
    public final Map<UUID, Integer> awaitingDoorAdd = new HashMap<UUID, Integer>();
    public final Map<UUID, Integer> awaitingDoorRemove = new HashMap<UUID, Integer>();
    private final Map<UUID, MarketFilter> marketFilters = new HashMap<UUID, MarketFilter>();
    private final Map<UUID, Integer> marketPages = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> confirmBuy = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> confirmSell = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> pendingTeleports = new HashMap<UUID, Integer>();
    private final Map<UUID, Location> teleportLocations = new HashMap<UUID, Location>();
    public final Map<UUID, Integer> wandSelections = new HashMap<UUID, Integer>();
    private int rentTask = -1;
    private int cleanupTask = -1;
    private boolean dynmapEnabled;
    private boolean bluemapEnabled;
    private Object dynmapMarkerAPI;
    private Object dynmapMarkerSet;
    private final List<MarkerSet> bluemapSets = new ArrayList<MarkerSet>();
    private Consumer<BlueMapAPI> bluemapEnableListener;
    private Consumer<BlueMapAPI> bluemapDisableListener;

    private boolean useMysql() {
        return this.getConfig().getBoolean("database.use-mysql", false);
    }

    public void onEnable() {
        if (!this.setupEconomy()) {
            this.getLogger().severe("Vault not found. Disabling.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.loadHouses();
        this.saveDefaultConfig();
        this.sqlDebug = this.getConfig().getBoolean("database.debug", false);
        this.connectDatabase();
        this.loadHousesFromDatabase();
        this.startAutoSave();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand("houses")).setExecutor((CommandExecutor)new HousesCommand(this));
        this.startRentTask();
        this.startCleanupTask();
        new Metrics(this, 26286);
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new HousesPlaceholder(this).register();
        }
        this.setupMapIntegrations();
        this.getLogger().info("  /-----------------------\\");
        this.getLogger().info("  \u00e2\u201d\u201a      AlphaCTX's       |");
        this.getLogger().info("  \u00e2\u201d\u201a        Houses         |");
        this.getLogger().info("  \u00e2\u201d\u201a         Plugin        |");
        this.getLogger().info("  \\-----------------------/");
        this.getLogger().info("        Houses Enabled!");
    }

    public void onDisable() {
        this.saveHousesSync();
        this.stopAutoSave();
        this.stopRentTask();
        this.stopCleanupTask();
        this.closeDatabase();
        this.cleanupMapIntegrations();
        this.getLogger().info("Houses Disabled!");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    private void loadHouses() {
        this.housesConfig = new YamlConfiguration();
    }

    public void reloadPlugin() {
        this.reloadConfig();
        this.loadHouses();
        this.sqlDebug = this.getConfig().getBoolean("database.debug", false);
        this.stopAutoSave();
        this.closeDatabase();
        this.connectDatabase();
        this.loadHousesFromDatabase();
        this.startAutoSave();
        this.cleanupMapIntegrations();
        this.setupMapIntegrations();
    }

    public void saveHouses() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, this::saveHousesToDatabase);
    }

    public void saveHousesSync() {
        this.saveHousesToDatabase();
    }

    public FileConfiguration getHousesConfig() {
        return this.housesConfig;
    }

    private void connectDatabase() {
        this.closeDatabase();
        try {
            this.sqlConnection = this.useMysql() ? this.connectMysql() : this.connectSqlite();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private Connection connectMysql() throws SQLException {
        String host = this.getConfig().getString("database.host");
        int port = this.getConfig().getInt("database.port", 3306);
        String user = this.getConfig().getString("database.user");
        String pass = this.getConfig().getString("database.pass");
        String db = this.getConfig().getString("database.database");
        String url = "jdbc:mysql://" + host + ":" + port + "/" + db + "?useSSL=false";
        this.debug("Connecting to " + url);
        Connection conn = DriverManager.getConnection(url, user, pass);
        try (PreparedStatement ps = conn.prepareStatement("CREATE TABLE IF NOT EXISTS houses (id INTEGER PRIMARY KEY, rent TINYINT(1), price DOUBLE, owner VARCHAR(36), next_rent BIGINT, world VARCHAR(64), x INT, y INT, z INT, doors TEXT, trusted TEXT)");){
            ps.executeUpdate();
        }
        this.debug("Connected to MySQL");
        return conn;
    }

    private Connection connectSqlite() throws SQLException {
        File file = new File(this.getDataFolder(), this.getConfig().getString("database.sqlite-file", "houses.db"));
        file.getParentFile().mkdirs();
        String url = "jdbc:sqlite:" + file.getAbsolutePath();
        this.debug("Connecting to " + url);
        Connection conn = DriverManager.getConnection(url);
        try (PreparedStatement ps = conn.prepareStatement("CREATE TABLE IF NOT EXISTS houses (id INTEGER PRIMARY KEY, rent TINYINT(1), price DOUBLE, owner VARCHAR(36), next_rent BIGINT, world VARCHAR(64), x INT, y INT, z INT, doors TEXT, trusted TEXT)");){
            ps.executeUpdate();
        }
        this.debug("Connected to SQLite");
        return conn;
    }

    private void closeDatabase() {
        if (this.sqlConnection != null) {
            try {
                this.sqlConnection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.sqlConnection = null;
            this.debug("Database connection closed");
        }
    }

    private void startAutoSave() {
        int interval = this.getConfig().getInt("database.save-interval", 10);
        if (interval <= 0) {
            return;
        }
        this.autoSaveTask = this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            this.saveHousesToDatabase();
            this.debug("Auto-saved houses to database");
        }, (long)interval * 20L, (long)interval * 20L).getTaskId();
    }

    private void stopAutoSave() {
        if (this.autoSaveTask != -1) {
            this.getServer().getScheduler().cancelTask(this.autoSaveTask);
            this.autoSaveTask = -1;
        }
    }

    private void startRentTask() {
        int interval = this.getConfig().getInt("rent.check-interval", 600);
        if (interval <= 0) {
            return;
        }
        this.rentTask = this.getServer().getScheduler().runTaskTimer((Plugin)this, this::checkRentPayments, (long)interval * 20L, (long)interval * 20L).getTaskId();
    }

    private void startCleanupTask() {
        int interval = this.getConfig().getInt("cleanup.check-interval", 86400);
        if (interval <= 0) {
            return;
        }
        this.cleanupTask = this.getServer().getScheduler().runTaskTimer((Plugin)this, this::checkInactiveOwners, (long)interval * 20L, (long)interval * 20L).getTaskId();
    }

    private void stopRentTask() {
        if (this.rentTask != -1) {
            this.getServer().getScheduler().cancelTask(this.rentTask);
            this.rentTask = -1;
        }
    }

    private void stopCleanupTask() {
        if (this.cleanupTask != -1) {
            this.getServer().getScheduler().cancelTask(this.cleanupTask);
            this.cleanupTask = -1;
        }
    }

    private void setupMapIntegrations() {
        this.dynmapEnabled = this.getConfig().getBoolean("integrations.dynmap", false);
        this.bluemapEnabled = this.getConfig().getBoolean("integrations.bluemap", false);
        if (this.dynmapEnabled) {
            this.initDynmap();
        }
        if (this.bluemapEnabled) {
            this.initBlueMap();
        }
    }

    private void cleanupMapIntegrations() {
        if (this.dynmapMarkerSet != null) {
            this.removeAllDynmapMarkers();
            this.dynmapMarkerSet = null;
            this.dynmapMarkerAPI = null;
        }
        if (!this.bluemapSets.isEmpty()) {
            this.removeAllBlueMapMarkers();
            this.bluemapSets.clear();
        }
        if (this.bluemapEnableListener != null) {
            BlueMapAPI.unregisterListener(this.bluemapEnableListener);
            BlueMapAPI.unregisterListener(this.bluemapDisableListener);
            this.bluemapEnableListener = null;
            this.bluemapDisableListener = null;
        }
    }

    private void initDynmap() {
        try {
            Plugin dyn = this.getServer().getPluginManager().getPlugin("dynmap");
            if (dyn == null) {
                return;
            }
            Class<?> apiClass = Class.forName("org.dynmap.DynmapCommonAPI");
            if (!apiClass.isInstance(dyn)) {
                return;
            }
            this.dynmapMarkerAPI = apiClass.getMethod("getMarkerAPI", new Class[0]).invoke((Object)dyn, new Object[0]);
            if (this.dynmapMarkerAPI == null) {
                return;
            }
            Class<?> markerAPI = Class.forName("org.dynmap.markers.MarkerAPI");
            Object set = markerAPI.getMethod("getMarkerSet", String.class).invoke(this.dynmapMarkerAPI, "houses");
            if (set == null) {
                set = markerAPI.getMethod("createMarkerSet", String.class, String.class, Set.class, Boolean.TYPE).invoke(this.dynmapMarkerAPI, "houses", "Houses", null, true);
            }
            this.dynmapMarkerSet = set;
        }
        catch (Exception ex) {
            this.getLogger().warning("Dynmap hook failed: " + ex.getMessage());
        }
        this.updateAllDynmapMarkers();
    }

    private void initBlueMap() {
        this.bluemapEnableListener = api -> {
            this.setupBlueMap((BlueMapAPI)api);
            this.updateAllBlueMapMarkers();
        };
        this.bluemapDisableListener = api -> {
            this.removeAllBlueMapMarkers();
            this.bluemapSets.clear();
        };
        BlueMapAPI.onEnable(this.bluemapEnableListener);
        BlueMapAPI.onDisable(this.bluemapDisableListener);
        BlueMapAPI.getInstance().ifPresent(this.bluemapEnableListener);
        this.getLogger().info("Houses hooked onto Bluemap!");
    }

    private void setupBlueMap(BlueMapAPI api) {
        this.bluemapSets.clear();
        for (BlueMapMap map : api.getMaps()) {
            MarkerSet set = (MarkerSet)map.getMarkerSets().get("houses");
            if (set == null) {
                set = MarkerSet.builder().label("Houses").toggleable(Boolean.valueOf(true)).build();
                map.getMarkerSets().put("houses", set);
            }
            this.bluemapSets.add(set);
        }
    }

    private void updateMapMarkers(int id) {
        this.updateDynmapMarker(id);
        this.updateBlueMapMarker(id);
    }

    private void removeMapMarker(int id) {
        this.removeDynmapMarker(id);
        this.removeBlueMapMarker(id);
    }

    private void updateAllMapMarkers() {
        if (this.housesConfig.isConfigurationSection("houses")) {
            for (String idStr : this.housesConfig.getConfigurationSection("houses").getKeys(false)) {
                try {
                    this.updateMapMarkers(Integer.parseInt(idStr));
                }
                catch (Exception exception) {}
            }
        }
    }

    private void removeAllDynmapMarkers() {
        if (this.dynmapMarkerSet == null) {
            return;
        }
        try {
            Set markers = (Set)this.dynmapMarkerSet.getClass().getMethod("getMarkers", new Class[0]).invoke(this.dynmapMarkerSet, new Object[0]);
            for (Object m : markers.toArray()) {
                m.getClass().getMethod("deleteMarker", new Class[0]).invoke(m, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeAllBlueMapMarkers() {
        for (MarkerSet set : this.bluemapSets) {
            set.getMarkers().clear();
        }
    }

    private void updateAllDynmapMarkers() {
        if (this.dynmapMarkerSet != null) {
            this.updateAllMapMarkers();
        }
    }

    private void updateAllBlueMapMarkers() {
        if (!this.bluemapSets.isEmpty()) {
            this.updateAllMapMarkers();
        }
    }

    private void updateDynmapMarker(int id) {
        if (this.dynmapMarkerSet == null) {
            return;
        }
        try {
            String path = "houses." + id;
            String world = this.housesConfig.getString(path + ".world");
            if (world == null) {
                return;
            }
            double x = this.housesConfig.getDouble(path + ".x") + 0.5;
            double y = this.housesConfig.getDouble(path + ".y");
            double z = this.housesConfig.getDouble(path + ".z") + 0.5;
            boolean rent = this.housesConfig.getBoolean(path + ".rent");
            double price = this.housesConfig.getDouble(path + ".price");
            String owner = this.housesConfig.getString(path + ".owner");
            String ownerName = owner == null ? null : Bukkit.getOfflinePlayer((UUID)UUID.fromString(owner)).getName();
            String label = "House #" + id;
            String desc = (ownerName == null ? "Available" : "Owner: " + ownerName) + "<br>Price: " + price + (rent ? " rent" : " buy");
            Class<?> markerSet = this.dynmapMarkerSet.getClass();
            Object marker = markerSet.getMethod("findMarker", String.class).invoke(this.dynmapMarkerSet, "house-" + id);
            Class<?> markerAPI = Class.forName("org.dynmap.markers.MarkerAPI");
            Object icon = markerAPI.getMethod("getMarkerIcon", String.class).invoke(this.dynmapMarkerAPI, "default");
            if (marker == null) {
                marker = markerSet.getMethod("createMarker", String.class, String.class, String.class, Double.TYPE, Double.TYPE, Double.TYPE, Class.forName("org.dynmap.markers.MarkerIcon"), Boolean.TYPE).invoke(this.dynmapMarkerSet, "house-" + id, label, world, x, y, z, icon, true);
            } else {
                marker.getClass().getMethod("setLocation", String.class, Double.TYPE, Double.TYPE, Double.TYPE).invoke(marker, world, x, y, z);
                marker.getClass().getMethod("setLabel", String.class).invoke(marker, label);
            }
            marker.getClass().getMethod("setDescription", String.class).invoke(marker, desc);
        }
        catch (Exception ex) {
            this.getLogger().warning("Dynmap marker error: " + ex.getMessage());
        }
    }

    private void removeDynmapMarker(int id) {
        if (this.dynmapMarkerSet == null) {
            return;
        }
        try {
            Object marker = this.dynmapMarkerSet.getClass().getMethod("findMarker", String.class).invoke(this.dynmapMarkerSet, "house-" + id);
            if (marker != null) {
                marker.getClass().getMethod("deleteMarker", new Class[0]).invoke(marker, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateBlueMapMarker(int id) {
        if (this.bluemapSets.isEmpty()) {
            return;
        }
        String path = "houses." + id;
        int x = this.housesConfig.getInt(path + ".x");
        int y = this.housesConfig.getInt(path + ".y");
        int z = this.housesConfig.getInt(path + ".z");
        boolean rent = this.housesConfig.getBoolean(path + ".rent");
        double price = this.housesConfig.getDouble(path + ".price");
        String owner = this.housesConfig.getString(path + ".owner");
        String ownerName = owner == null ? null : Bukkit.getOfflinePlayer((UUID)UUID.fromString(owner)).getName();
        String label = "<b>[" + (rent ? "Rentable" : "Purchasable") + " property]</b>";
        StringBuilder descBuilder = new StringBuilder();
        descBuilder.append("Price: ").append(price).append("<br>Number: ").append(id).append("<br>Owner: ").append(ownerName == null ? "none" : ownerName);
        String desc = descBuilder.toString();
        Vector3d pos = new Vector3d((double)x + 0.5, (double)y, (double)z + 0.5);
        for (MarkerSet set : this.bluemapSets) {
            POIMarker marker;
            Map markers = set.getMarkers();
            Marker base = (Marker)markers.get("house-" + id);
            if (!(base instanceof POIMarker)) {
                marker = ((POIMarker.Builder)((POIMarker.Builder)POIMarker.builder().label(label)).position(pos)).detail(desc).build();
                markers.put("house-" + id, marker);
                continue;
            }
            marker = (POIMarker)base;
            marker.setPosition(pos);
            marker.setLabel(label);
            marker.setDetail(desc);
        }
    }

    private void removeBlueMapMarker(int id) {
        if (this.bluemapSets.isEmpty()) {
            return;
        }
        for (MarkerSet set : this.bluemapSets) {
            set.getMarkers().remove("house-" + id);
        }
    }

    private void checkRentPayments() {
        this.checkRentPayments(null);
    }

    private void checkRentPayments(UUID only) {
        long period = this.getConfig().getLong("rent.period", 2400L) * 1000L;
        long now = System.currentTimeMillis();
        if (this.housesConfig.isConfigurationSection("houses")) {
            for (String idStr : this.housesConfig.getConfigurationSection("houses").getKeys(false)) {
                OfflinePlayer op;
                long next;
                String owner;
                String path = "houses." + idStr;
                if (!this.housesConfig.getBoolean(path + ".rent") || (owner = this.housesConfig.getString(path + ".owner")) == null || only != null && !owner.equals(only.toString()) || now < (next = this.housesConfig.getLong(path + ".nextRent", 0L)) || !(op = Bukkit.getOfflinePlayer((UUID)UUID.fromString(owner))).isOnline()) continue;
                double price = this.housesConfig.getDouble(path + ".price");
                if (this.economy.has(op, price)) {
                    this.economy.withdrawPlayer(op, price);
                    this.housesConfig.set(path + ".nextRent", (Object)(now + period));
                    this.sendConfiguredMessage(op.getPlayer(), "rent-paid", Integer.parseInt(idStr));
                    continue;
                }
                this.housesConfig.set(path + ".owner", null);
                this.housesConfig.set(path + ".trusted", new ArrayList());
                this.housesConfig.set(path + ".nextRent", null);
                this.updateHouseSign(Integer.parseInt(idStr), null);
                this.sendConfiguredMessage(op.getPlayer(), "rent-stopped", Integer.parseInt(idStr));
            }
            this.saveHouses();
        }
    }

    private void checkInactiveOwners() {
        int days = this.getConfig().getInt("cleanup.inactive-days", 30);
        long limit = System.currentTimeMillis() - (long)days * 86400000L;
        if (this.housesConfig.isConfigurationSection("houses")) {
            for (String idStr : this.housesConfig.getConfigurationSection("houses").getKeys(false)) {
                OfflinePlayer op;
                String path = "houses." + idStr;
                String owner = this.housesConfig.getString(path + ".owner");
                if (owner == null || (op = Bukkit.getOfflinePlayer((UUID)UUID.fromString(owner))).isOnline() || op.getLastPlayed() >= limit) continue;
                this.housesConfig.set(path + ".owner", null);
                this.housesConfig.set(path + ".trusted", new ArrayList());
                this.housesConfig.set(path + ".nextRent", null);
                this.updateHouseSign(Integer.parseInt(idStr), null);
                if (!op.isOnline()) continue;
                this.sendConfiguredMessage(op.getPlayer(), "inactive-removed", Integer.parseInt(idStr));
            }
            this.saveHouses();
        }
    }

    private void loadHousesFromDatabase() {
        this.loadHousesFromConnection(this.sqlConnection);
    }

    private void loadHousesFromConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        this.debug("Loading houses from database");
        try (Statement st = conn.createStatement();){
            ResultSet rs = st.executeQuery("SELECT * FROM houses");
            int lastId = 0;
            this.housesConfig.set("houses", null);
            while (rs.next()) {
                int id = rs.getInt("id");
                lastId = Math.max(lastId, id);
                String path = "houses." + id;
                this.housesConfig.set(path + ".rent", (Object)rs.getBoolean("rent"));
                this.housesConfig.set(path + ".price", (Object)rs.getDouble("price"));
                this.housesConfig.set(path + ".owner", (Object)rs.getString("owner"));
                this.housesConfig.set(path + ".nextRent", (Object)rs.getLong("next_rent"));
                this.housesConfig.set(path + ".world", (Object)rs.getString("world"));
                this.housesConfig.set(path + ".x", (Object)rs.getInt("x"));
                this.housesConfig.set(path + ".y", (Object)rs.getInt("y"));
                this.housesConfig.set(path + ".z", (Object)rs.getInt("z"));
                String doors = rs.getString("doors");
                this.housesConfig.set(path + ".doors", doors == null || doors.isEmpty() ? new ArrayList() : Arrays.asList(doors.split(";")));
                String trusted = rs.getString("trusted");
                this.housesConfig.set(path + ".trusted", trusted == null || trusted.isEmpty() ? new ArrayList() : Arrays.asList(trusted.split(";")));
            }
            this.housesConfig.set("lastId", (Object)lastId);
            this.updateAllMapMarkers();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void saveHousesToDatabase() {
        this.saveHousesToConnection(this.sqlConnection);
    }

    private void saveHousesToConnection(Connection conn) {
        block42: {
            if (conn == null) {
                return;
            }
            this.debug("Saving houses to database");
            try {
                HashSet<Integer> dbIds = new HashSet<Integer>();
                try (Statement st = conn.createStatement();
                     ResultSet rs = st.executeQuery("SELECT id FROM houses");){
                    while (rs.next()) {
                        dbIds.add(rs.getInt("id"));
                    }
                }
                boolean sqlite = false;
                try {
                    sqlite = conn.getMetaData().getURL().startsWith("jdbc:sqlite");
                }
                catch (SQLException rs) {
                    // empty catch block
                }
                String sqlUpsert = sqlite ? "INSERT INTO houses (id, rent, price, owner, next_rent, world, x, y, z, doors, trusted) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON CONFLICT(id) DO UPDATE SET rent=excluded.rent, price=excluded.price, owner=excluded.owner, next_rent=excluded.next_rent, world=excluded.world, x=excluded.x, y=excluded.y, z=excluded.z, doors=excluded.doors, trusted=excluded.trusted" : "INSERT INTO houses (id, rent, price, owner, next_rent, world, x, y, z, doors, trusted) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE rent=VALUES(rent), price=VALUES(price), owner=VALUES(owner), next_rent=VALUES(next_rent), world=VALUES(world), x=VALUES(x), y=VALUES(y), z=VALUES(z), doors=VALUES(doors), trusted=VALUES(trusted)";
                try (PreparedStatement ps = conn.prepareStatement(sqlUpsert, 1);){
                    Object trusted;
                    HashSet<Integer> configIds = new HashSet<Integer>();
                    if (this.housesConfig.isConfigurationSection("houses")) {
                        for (String idStr : this.housesConfig.getConfigurationSection("houses").getKeys(false)) {
                            int id = Integer.parseInt(idStr);
                            configIds.add(id);
                            String path = "houses." + id;
                            ps.setInt(1, id);
                            ps.setBoolean(2, this.housesConfig.getBoolean(path + ".rent"));
                            ps.setDouble(3, this.housesConfig.getDouble(path + ".price"));
                            ps.setString(4, this.housesConfig.getString(path + ".owner"));
                            ps.setLong(5, this.housesConfig.getLong(path + ".nextRent", 0L));
                            ps.setString(6, this.housesConfig.getString(path + ".world"));
                            ps.setInt(7, this.housesConfig.getInt(path + ".x"));
                            ps.setInt(8, this.housesConfig.getInt(path + ".y"));
                            ps.setInt(9, this.housesConfig.getInt(path + ".z"));
                            List doors = this.housesConfig.getStringList(path + ".doors");
                            trusted = this.housesConfig.getStringList(path + ".trusted");
                            ps.setString(10, String.join((CharSequence)";", doors));
                            ps.setString(11, String.join((CharSequence)";", (Iterable<? extends CharSequence>)trusted));
                            ps.addBatch();
                        }
                    }
                    ps.executeBatch();
                    try (ResultSet rs = ps.getGeneratedKeys();){
                        while (rs.next()) {
                            this.debug("Upserted house id=" + rs.getInt(1));
                        }
                    }
                    HashSet toDelete = new HashSet(dbIds);
                    toDelete.removeAll(configIds);
                    if (toDelete.isEmpty()) break block42;
                    String placeholders = toDelete.stream().map(i -> "?").collect(Collectors.joining(","));
                    String sqlDel = "DELETE FROM houses WHERE id IN (" + placeholders + ")";
                    try (PreparedStatement psDel = conn.prepareStatement(sqlDel);){
                        int i2 = 1;
                        trusted = toDelete.iterator();
                        while (trusted.hasNext()) {
                            int id = (Integer)trusted.next();
                            psDel.setInt(i2++, id);
                        }
                        int deleted = psDel.executeUpdate();
                        this.debug("Deleted " + deleted + " houses: " + toDelete);
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void backupToMysql() {
        try (Connection source = this.connectSqlite();
             Connection target = this.connectMysql();){
            this.loadHousesFromConnection(source);
            this.saveHousesToConnection(target);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void backupToSqlite() {
        try (Connection source = this.connectMysql();
             Connection target = this.connectSqlite();){
            this.loadHousesFromConnection(source);
            this.saveHousesToConnection(target);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void sendConfiguredMessage(Player player, String key, int id) {
        this.sendConfiguredMessage(player, key, id, -1.0);
    }

    private void sendConfiguredMessage(Player player, String key, int id, double price) {
        String msg = this.getConfig().getString("messages." + key);
        if (msg != null) {
            if ((msg = msg.replace("{id}", String.valueOf(id))).contains("{price}")) {
                msg = msg.replace("{price}", String.valueOf(price));
            }
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
        }
    }

    @EventHandler
    public void onSignChange(SignChangeEvent e) {
        if (!e.getPlayer().hasPermission("houses.admin")) {
            return;
        }
        String line0 = ChatColor.stripColor((String)e.getLine(0));
        if ("[House]".equalsIgnoreCase(line0)) {
            this.createHouseSign(e, false);
        } else if ("[Rent]".equalsIgnoreCase(line0)) {
            this.createHouseSign(e, true);
        }
    }

    private void createHouseSign(SignChangeEvent e, boolean rent) {
        String priceLine = e.getLine(1).replace("$", "");
        double price = 0.0;
        try {
            price = Double.parseDouble(priceLine);
        }
        catch (Exception ex) {
            e.getPlayer().sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "Invalid price");
            return;
        }
        if (price <= 0.0) {
            e.getPlayer().sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "Price must be positive");
            return;
        }
        int id = this.housesConfig.getInt("lastId", 0) + 1;
        this.housesConfig.set("lastId", (Object)id);
        String path = "houses." + id;
        this.housesConfig.set(path + ".rent", (Object)rent);
        this.housesConfig.set(path + ".price", (Object)price);
        this.housesConfig.set(path + ".owner", null);
        Block b = e.getBlock();
        this.housesConfig.set(path + ".world", (Object)b.getWorld().getName());
        this.housesConfig.set(path + ".x", (Object)b.getX());
        this.housesConfig.set(path + ".y", (Object)b.getY());
        this.housesConfig.set(path + ".z", (Object)b.getZ());
        this.saveHouses();
        e.setLine(0, ChatColor.GREEN + (rent ? "[Rent]" : "[House]"));
        e.setLine(1, "$" + price);
        e.setLine(2, "");
        e.setLine(3, "ID: " + id);
        this.updateMapMarkers(id);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        int id;
        Block b = e.getBlock();
        if (!this.isSign(b.getType())) {
            return;
        }
        if (!(b.getState() instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)b.getState();
        String line0 = ChatColor.stripColor((String)sign.getLine(0));
        if (!line0.equalsIgnoreCase("[House]") && !line0.equalsIgnoreCase("[Rent]")) {
            return;
        }
        String idPart = ChatColor.stripColor((String)sign.getLine(3));
        if (!idPart.toLowerCase().startsWith("id:")) {
            return;
        }
        try {
            id = Integer.parseInt(idPart.substring(3).trim());
        }
        catch (Exception ex) {
            return;
        }
        if (e.getPlayer().hasPermission("houses.admin")) {
            this.housesConfig.set("houses." + id, null);
            this.saveHouses();
            this.removeMapMarker(id);
            e.getPlayer().sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.GREEN + "House " + id + " removed");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInteract(PlayerInteractEvent e) {
        int id;
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = e.getClickedBlock();
        if (block == null) {
            return;
        }
        Player p = e.getPlayer();
        ItemStack hand = e.getItem();
        if (this.isWand(hand) && p.hasPermission("houses.admin")) {
            this.handleWandUse(p, block);
            e.setCancelled(true);
            return;
        }
        Material type = block.getType();
        if (this.isDoor(type)) {
            UUID uid = p.getUniqueId();
            if (this.awaitingDoorAdd.containsKey(uid)) {
                int id2 = this.awaitingDoorAdd.remove(uid);
                this.addDoorToHouse(id2, block);
                p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.GREEN + "Door added to house " + id2);
                e.setCancelled(true);
                return;
            }
            if (this.awaitingDoorRemove.containsKey(uid)) {
                int id3 = this.awaitingDoorRemove.remove(uid);
                this.removeDoorFromHouse(id3, block);
                p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.GREEN + "Door removed from house " + id3);
                e.setCancelled(true);
                return;
            }
            int doorHouse = this.getHouseIdByDoor(block);
            if (doorHouse != -1) {
                String owner = this.housesConfig.getString("houses." + doorHouse + ".owner");
                boolean trusted = this.isTrusted(doorHouse, uid);
                if (owner == null || !owner.equals(uid.toString()) && !trusted) {
                    this.sendConfiguredMessage(p, "door-locked", doorHouse);
                    e.setCancelled(true);
                    return;
                }
            }
        }
        if (!this.isSign(type)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        String line0 = ChatColor.stripColor((String)sign.getLine(0));
        if (!line0.equalsIgnoreCase("[House]") && !line0.equalsIgnoreCase("[Rent]")) {
            return;
        }
        String idPart = ChatColor.stripColor((String)sign.getLine(3));
        if (!idPart.toLowerCase().startsWith("id:")) {
            return;
        }
        try {
            id = Integer.parseInt(idPart.substring(3).trim());
        }
        catch (Exception ex) {
            return;
        }
        String path = "houses." + id;
        boolean rent = this.housesConfig.getBoolean(path + ".rent");
        double price = this.housesConfig.getDouble(path + ".price");
        String owner = this.housesConfig.getString(path + ".owner");
        if (owner == null) {
            p.sendMessage(ChatColor.YELLOW + (rent ? "Rent" : "Buy") + " price: " + price);
            if (p.isSneaking()) {
                int max = this.getConfig().getInt("max-houses-per-player", 0);
                if (max > 0) {
                    int owned = 0;
                    if (this.housesConfig.isConfigurationSection("houses")) {
                        for (String hid : this.housesConfig.getConfigurationSection("houses").getKeys(false)) {
                            if (!p.getUniqueId().toString().equals(this.housesConfig.getString("houses." + hid + ".owner"))) continue;
                            ++owned;
                        }
                    }
                    if (owned >= max) {
                        p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "You have reached the house limit of " + max);
                        return;
                    }
                }
                if (this.economy.getBalance((OfflinePlayer)p) >= price) {
                    this.economy.withdrawPlayer((OfflinePlayer)p, price);
                    this.housesConfig.set(path + ".owner", (Object)p.getUniqueId().toString());
                    this.saveHouses();
                    this.updateHouseSign(id, p.getName());
                    this.sendConfiguredMessage(p, rent ? "rent-success" : "buy-success", id);
                } else {
                    p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "Not enough money");
                }
            } else {
                p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.GRAY + "Sneak and right click to confirm");
            }
        } else if (owner.equals(p.getUniqueId().toString())) {
            double percent = this.getConfig().getDouble("sell-percentage", 0.75);
            double sellPrice = price * percent;
            this.sendConfiguredMessage(p, "sell-price-info", id, sellPrice);
            if (p.isSneaking()) {
                this.economy.depositPlayer((OfflinePlayer)p, sellPrice);
                this.housesConfig.set(path + ".owner", null);
                this.saveHouses();
                this.updateHouseSign(id, null);
                this.sendConfiguredMessage(p, rent ? "stop-rent-success" : "sell-success", id);
            } else {
                p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.GRAY + "Sneak and right click to confirm sale");
            }
        } else {
            p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "Someone else owns this.");
        }
    }

    private boolean isDoor(Material m) {
        return m.name().endsWith("_DOOR");
    }

    private boolean isSign(Material m) {
        String name = m.name();
        return name.endsWith("_SIGN") || name.endsWith("_WALL_SIGN");
    }

    private String serialize(Block b) {
        return b.getWorld().getName() + "," + b.getX() + "," + b.getY() + "," + b.getZ();
    }

    private void addDoorToHouse(int id, Block door) {
        String ser;
        String path = "houses." + id + ".doors";
        List doors = this.housesConfig.getStringList(path);
        if (!doors.contains(ser = this.serialize(door))) {
            doors.add(ser);
            this.housesConfig.set(path, (Object)doors);
            this.saveHouses();
        }
    }

    private void removeDoorFromHouse(int id, Block door) {
        String ser;
        String path = "houses." + id + ".doors";
        List doors = this.housesConfig.getStringList(path);
        if (doors.remove(ser = this.serialize(door))) {
            this.housesConfig.set(path, (Object)doors);
            this.saveHouses();
        }
    }

    private List<String> getTrusted(int id) {
        return new ArrayList<String>(this.housesConfig.getStringList("houses." + id + ".trusted"));
    }

    private boolean isTrusted(int id, UUID uuid) {
        return this.getTrusted(id).contains(uuid.toString());
    }

    public void addTrusted(int id, UUID uuid) {
        String s;
        List<String> list = this.getTrusted(id);
        if (!list.contains(s = uuid.toString())) {
            list.add(s);
            this.housesConfig.set("houses." + id + ".trusted", list);
            this.saveHouses();
        }
    }

    public void removeTrusted(int id, UUID uuid) {
        List<String> list = this.getTrusted(id);
        if (list.remove(uuid.toString())) {
            this.housesConfig.set("houses." + id + ".trusted", list);
            this.saveHouses();
        }
    }

    private int getHouseIdByDoor(Block b) {
        if (!this.housesConfig.isConfigurationSection("houses")) {
            return -1;
        }
        String serClicked = this.serialize(b);
        String serOther = null;
        BlockData data = b.getBlockData();
        if (data instanceof Bisected) {
            Bisected bisected = (Bisected)data;
            Block other = bisected.getHalf() == Bisected.Half.TOP ? b.getRelative(BlockFace.DOWN) : b.getRelative(BlockFace.UP);
            serOther = this.serialize(other);
        }
        for (String idStr : this.housesConfig.getConfigurationSection("houses").getKeys(false)) {
            List doors = this.housesConfig.getStringList("houses." + idStr + ".doors");
            if (!doors.contains(serClicked) && (serOther == null || !doors.contains(serOther))) continue;
            try {
                return Integer.parseInt(idStr);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return -1;
    }

    public void updateHouseSign(int id, String ownerName) {
        String path = "houses." + id + ".";
        String world = this.housesConfig.getString(path + "world");
        if (world == null) {
            return;
        }
        Block b = Bukkit.getWorld((String)world).getBlockAt(this.housesConfig.getInt(path + "x"), this.housesConfig.getInt(path + "y"), this.housesConfig.getInt(path + "z"));
        if (b.getState() instanceof Sign) {
            Sign sign = (Sign)b.getState();
            double price = this.housesConfig.getDouble(path + "price");
            sign.setLine(1, "$" + price);
            sign.setLine(2, ownerName == null ? "" : "Owner:" + ownerName);
            sign.setLine(3, "ID: " + id);
            sign.update();
        }
        this.updateMapMarkers(id);
    }

    private void buyHouse(Player p, int id) {
        String path = "houses." + id;
        boolean rent = this.housesConfig.getBoolean(path + ".rent");
        double price = this.housesConfig.getDouble(path + ".price");
        int max = this.getConfig().getInt("max-houses-per-player", 0);
        if (max > 0) {
            int owned = 0;
            if (this.housesConfig.isConfigurationSection("houses")) {
                for (String hid : this.housesConfig.getConfigurationSection("houses").getKeys(false)) {
                    if (!p.getUniqueId().toString().equals(this.housesConfig.getString("houses." + hid + ".owner"))) continue;
                    ++owned;
                }
            }
            if (owned >= max) {
                p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "You have reached the house limit of " + max);
                return;
            }
        }
        if (this.economy.getBalance((OfflinePlayer)p) >= price) {
            this.economy.withdrawPlayer((OfflinePlayer)p, price);
            this.housesConfig.set(path + ".owner", (Object)p.getUniqueId().toString());
            this.housesConfig.set(path + ".trusted", new ArrayList());
            if (rent) {
                long period = this.getConfig().getLong("rent.period", 2400L) * 1000L;
                this.housesConfig.set(path + ".nextRent", (Object)(System.currentTimeMillis() + period));
            }
            this.saveHouses();
            this.updateHouseSign(id, p.getName());
            this.sendConfiguredMessage(p, rent ? "rent-success" : "buy-success", id);
        } else {
            p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "Not enough money");
        }
    }

    private void sellHouse(Player p, int id) {
        String path = "houses." + id;
        boolean rent = this.housesConfig.getBoolean(path + ".rent");
        double price = this.housesConfig.getDouble(path + ".price");
        double percent = this.getConfig().getDouble("sell-percentage", 0.75);
        double sellPrice = price * percent;
        this.economy.depositPlayer((OfflinePlayer)p, sellPrice);
        this.housesConfig.set(path + ".owner", null);
        this.housesConfig.set(path + ".trusted", new ArrayList());
        this.housesConfig.set(path + ".nextRent", null);
        this.saveHouses();
        this.updateHouseSign(id, null);
        this.sendConfiguredMessage(p, rent ? "stop-rent-success" : "sell-success", id);
    }

    private void teleportToHouse(Player p, int id) {
        String path = "houses." + id + ".";
        String world = this.housesConfig.getString(path + "world");
        if (world == null) {
            p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "Location not found");
            return;
        }
        int x = this.housesConfig.getInt(path + "x");
        int y = this.housesConfig.getInt(path + "y");
        int z = this.housesConfig.getInt(path + "z");
        int wait = this.getConfig().getInt("teleport-wait", 5);
        p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.GREEN + "Teleporting in " + wait + " seconds...");
        Location startLoc = p.getLocation();
        int task = Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            if (p.isOnline()) {
                this.pendingTeleports.remove(p.getUniqueId());
                this.teleportLocations.remove(p.getUniqueId());
                p.teleport(new Location(Bukkit.getWorld((String)world), (double)x, (double)y, (double)z));
            }
        }, 20L * (long)wait).getTaskId();
        this.pendingTeleports.put(p.getUniqueId(), task);
        this.teleportLocations.put(p.getUniqueId(), startLoc);
    }

    public void openMarket(Player p, MarketFilter filter) {
        this.openMarket(p, filter, 0);
    }

    public void openMarket(Player p, MarketFilter filter, int page) {
        this.marketFilters.put(p.getUniqueId(), filter);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (this.housesConfig.isConfigurationSection("houses")) {
            for (String idStr : this.housesConfig.getConfigurationSection("houses").getKeys(false)) {
                String owner = this.housesConfig.getString("houses." + idStr + ".owner");
                int id = Integer.parseInt(idStr);
                if (filter == MarketFilter.AVAILABLE && owner != null || filter == MarketFilter.OWNED && !p.getUniqueId().toString().equals(owner)) continue;
                ids.add(id);
            }
        }
        int pages = Math.max(1, (ids.size() + 26) / 27);
        if (page < 0) {
            page = 0;
        }
        if (page >= pages) {
            page = pages - 1;
        }
        this.marketPages.put(p.getUniqueId(), page);
        Inventory inv = Bukkit.createInventory(null, (int)45, (String)"House Market");
        inv.setItem(0, this.createButton(Material.LIME_DYE, ChatColor.GREEN + "All"));
        inv.setItem(1, this.createButton(Material.BLUE_DYE, ChatColor.BLUE + "Available"));
        inv.setItem(2, this.createButton(Material.YELLOW_DYE, ChatColor.YELLOW + "Owned"));
        int start = page * 27;
        for (int i = 0; i < 27 && start + i < ids.size(); ++i) {
            int id = (Integer)ids.get(start + i);
            String path = "houses." + id;
            boolean rent = this.housesConfig.getBoolean(path + ".rent");
            double price = this.housesConfig.getDouble(path + ".price");
            ItemStack item = new ItemStack(rent ? Material.OAK_DOOR : Material.BRICKS);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(ChatColor.GOLD + "House #" + id);
            meta.setLore(Arrays.asList(ChatColor.YELLOW + "Price: " + price, ChatColor.GRAY + (rent ? "Rent" : "Buy")));
            item.setItemMeta(meta);
            inv.setItem(9 + i, item);
        }
        if (page > 0) {
            inv.setItem(36, this.createButton(Material.ARROW, ChatColor.YELLOW + "Prev"));
        }
        inv.setItem(40, this.createButton(Material.PAPER, ChatColor.YELLOW + "Page " + (page + 1) + "/" + pages));
        if (page < pages - 1) {
            inv.setItem(44, this.createButton(Material.ARROW, ChatColor.YELLOW + "Next"));
        }
        p.openInventory(inv);
    }

    private ItemStack createButton(Material mat, String name) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    private void openHouseDetails(Player p, int id) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)("House #" + id));
        String path = "houses." + id;
        boolean rent = this.housesConfig.getBoolean(path + ".rent");
        double price = this.housesConfig.getDouble(path + ".price");
        String owner = this.housesConfig.getString(path + ".owner");
        ItemStack info = new ItemStack(Material.PAPER);
        ItemMeta meta = info.getItemMeta();
        meta.setDisplayName(ChatColor.GOLD + "House " + id);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(ChatColor.YELLOW + "Price: " + price);
        lore.add(ChatColor.GRAY + (rent ? "Rent" : "Buy"));
        lore.add(ChatColor.GRAY + "Owner: " + (owner == null ? "none" : Bukkit.getOfflinePlayer((UUID)UUID.fromString(owner)).getName()));
        meta.setLore(lore);
        info.setItemMeta(meta);
        inv.setItem(11, info);
        ItemStack action = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta aMeta = action.getItemMeta();
        if (owner == null) {
            aMeta.setDisplayName(ChatColor.GREEN + (rent ? "Rent" : "Buy"));
        } else if (owner.equals(p.getUniqueId().toString())) {
            aMeta.setDisplayName(ChatColor.GREEN + (rent ? "Stop Rent" : "Sell"));
        } else {
            aMeta.setDisplayName(ChatColor.RED + "Not yours");
        }
        action.setItemMeta(aMeta);
        inv.setItem(15, action);
        ItemStack tp = new ItemStack(Material.ENDER_PEARL);
        ItemMeta tMeta = tp.getItemMeta();
        tMeta.setDisplayName(ChatColor.AQUA + "Teleport");
        tp.setItemMeta(tMeta);
        inv.setItem(13, tp);
        inv.setItem(22, this.createButton(Material.ARROW, ChatColor.RED + "Back"));
        p.openInventory(inv);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        String title = e.getView().getTitle();
        if (title.equals("House Market")) {
            String name;
            ItemStack item;
            e.setCancelled(true);
            int slot = e.getRawSlot();
            if (slot == 0) {
                this.openMarket(p, MarketFilter.ALL, 0);
                return;
            }
            if (slot == 1) {
                this.openMarket(p, MarketFilter.AVAILABLE, 0);
                return;
            }
            if (slot == 2) {
                this.openMarket(p, MarketFilter.OWNED, 0);
                return;
            }
            MarketFilter filter = this.marketFilters.getOrDefault(p.getUniqueId(), MarketFilter.ALL);
            int page = this.marketPages.getOrDefault(p.getUniqueId(), 0);
            if (slot == 36) {
                this.openMarket(p, filter, page - 1);
                return;
            }
            if (slot == 44) {
                this.openMarket(p, filter, page + 1);
                return;
            }
            if (slot >= 9 && slot < 36 && (item = e.getCurrentItem()) != null && item.hasItemMeta() && (name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName())).startsWith("House #")) {
                int id = Integer.parseInt(name.substring(7));
                this.openHouseDetails(p, id);
            }
        } else if (title.startsWith("House #")) {
            e.setCancelled(true);
            int id = Integer.parseInt(title.substring(7));
            String path = "houses." + id;
            String owner = this.housesConfig.getString(path + ".owner");
            ItemStack item = e.getCurrentItem();
            if (item == null || !item.hasItemMeta()) {
                return;
            }
            String name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
            if (name.equalsIgnoreCase("Buy") || name.equalsIgnoreCase("Rent")) {
                if (owner == null) {
                    if (!this.confirmBuy.containsKey(p.getUniqueId()) || this.confirmBuy.get(p.getUniqueId()) != id) {
                        this.confirmBuy.put(p.getUniqueId(), id);
                        p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.GREEN + "Click again to confirm purchase.");
                    } else {
                        this.confirmBuy.remove(p.getUniqueId());
                        this.buyHouse(p, id);
                        p.closeInventory();
                    }
                }
            } else if (name.equalsIgnoreCase("Sell") || name.equalsIgnoreCase("Stop Rent")) {
                if (owner != null && owner.equals(p.getUniqueId().toString())) {
                    if (!this.confirmSell.containsKey(p.getUniqueId()) || this.confirmSell.get(p.getUniqueId()) != id) {
                        this.confirmSell.put(p.getUniqueId(), id);
                        p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.GREEN + "Click again to confirm sale.");
                    } else {
                        this.confirmSell.remove(p.getUniqueId());
                        this.sellHouse(p, id);
                        p.closeInventory();
                    }
                }
            } else if (name.equalsIgnoreCase("Teleport")) {
                p.closeInventory();
                this.teleportToHouse(p, id);
            } else if (name.equalsIgnoreCase("Back")) {
                MarketFilter filter = this.marketFilters.getOrDefault(p.getUniqueId(), MarketFilter.ALL);
                int page = this.marketPages.getOrDefault(p.getUniqueId(), 0);
                this.openMarket(p, filter, page);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        UUID uid = e.getPlayer().getUniqueId();
        this.confirmBuy.remove(uid);
        this.confirmSell.remove(uid);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        Location start;
        UUID uid = e.getPlayer().getUniqueId();
        if (this.pendingTeleports.containsKey(uid) && (start = this.teleportLocations.get(uid)) != null && e.getFrom().distanceSquared(start) > 0.1) {
            this.cancelTeleport(e.getPlayer());
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent e) {
        Player p;
        if (e.getEntity() instanceof Player && this.pendingTeleports.containsKey((p = (Player)e.getEntity()).getUniqueId())) {
            this.cancelTeleport(p);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        UUID uid = e.getPlayer().getUniqueId();
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.checkRentPayments(uid), 20L);
    }

    private void cancelTeleport(Player p) {
        Integer task = this.pendingTeleports.remove(p.getUniqueId());
        this.teleportLocations.remove(p.getUniqueId());
        if (task != null) {
            Bukkit.getScheduler().cancelTask(task.intValue());
            p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "Teleport cancelled");
        }
    }

    private boolean isWand(ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.getType() != Material.BLAZE_ROD) {
            return false;
        }
        if (!item.hasItemMeta()) {
            return false;
        }
        String name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
        return "HOUSE WAND".equalsIgnoreCase(name);
    }

    private void handleWandUse(Player p, Block block) {
        Sign sign;
        String line0;
        UUID uid = p.getUniqueId();
        Material type = block.getType();
        if (this.isSign(type) && block.getState() instanceof Sign && ((line0 = ChatColor.stripColor((String)(sign = (Sign)block.getState()).getLine(0))).equalsIgnoreCase("[House]") || line0.equalsIgnoreCase("[Rent]"))) {
            String idPart = ChatColor.stripColor((String)sign.getLine(3));
            if (idPart.toLowerCase().startsWith("id:")) {
                try {
                    int id = Integer.parseInt(idPart.substring(3).trim());
                    this.wandSelections.put(uid, id);
                    p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.GREEN + "Selected house " + id);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        Integer sel = this.wandSelections.get(uid);
        if (sel == null) {
            p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "No house selected");
            return;
        }
        if (this.isDoor(type)) {
            if (this.isDoorInHouse(sel, block)) {
                this.removeDoorFromHouse(sel, block);
                p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.GREEN + "Door removed from house " + sel);
            } else {
                this.addDoorToHouse(sel, block);
                p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.GREEN + "Door added to house " + sel);
            }
            return;
        }
    }

    private boolean isDoorInHouse(int id, Block door) {
        String ser1;
        List doors = this.housesConfig.getStringList("houses." + id + ".doors");
        if (doors.contains(ser1 = this.serialize(door))) {
            return true;
        }
        Block other = this.getOtherHalf(door);
        return doors.contains(this.serialize(other));
    }

    private Block getOtherHalf(Block door) {
        BlockData data = door.getBlockData();
        if (data instanceof Bisected) {
            Bisected bis = (Bisected)data;
            return bis.getHalf() == Bisected.Half.TOP ? door.getRelative(BlockFace.DOWN) : door.getRelative(BlockFace.UP);
        }
        return door;
    }

    private void debug(String msg) {
        if (this.sqlDebug) {
            this.getLogger().info("[SQL] " + msg);
        }
    }

    public static enum MarketFilter {
        ALL,
        AVAILABLE,
        OWNED;

    }
}

