/*
 * Decompiled with CFR 0.152.
 */
package com.alphactx;

import com.alphactx.MinecraftHouses;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class HousesCommand
implements CommandExecutor {
    private final MinecraftHouses plugin;

    public HousesCommand(MinecraftHouses plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players");
            return true;
        }
        Player p = (Player)sender;
        FileConfiguration cfg = this.plugin.getHousesConfig();
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            this.sendHelp(p);
            return true;
        }
        if (args[0].equalsIgnoreCase("list")) {
            p.sendMessage(ChatColor.YELLOW + "Houses:");
            if (cfg.isConfigurationSection("houses")) {
                for (String id : cfg.getConfigurationSection("houses").getKeys(false)) {
                    String owner = cfg.getString("houses." + id + ".owner");
                    p.sendMessage(ChatColor.GRAY + "#" + id + " owner:" + (owner == null ? "none" : owner));
                }
            } else {
                p.sendMessage(ChatColor.GRAY + "(none)");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("owned")) {
            p.sendMessage(ChatColor.YELLOW + "Owned houses:");
            if (cfg.isConfigurationSection("houses")) {
                for (String id : cfg.getConfigurationSection("houses").getKeys(false)) {
                    String owner = cfg.getString("houses." + id + ".owner");
                    if (!p.getUniqueId().toString().equals(owner)) continue;
                    p.sendMessage(ChatColor.GREEN + "#" + id);
                }
            } else {
                p.sendMessage(ChatColor.GRAY + "(none)");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("info")) {
            int id;
            if (args.length < 2) {
                p.sendMessage(ChatColor.RED + "/houses info <id>");
                return true;
            }
            try {
                id = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ex) {
                p.sendMessage(ChatColor.RED + "Invalid id");
                return true;
            }
            if (!cfg.isConfigurationSection("houses." + id)) {
                p.sendMessage(ChatColor.RED + "Unknown house");
                return true;
            }
            String path = "houses." + id;
            boolean rent = cfg.getBoolean(path + ".rent");
            double price = cfg.getDouble(path + ".price");
            String owner = cfg.getString(path + ".owner");
            p.sendMessage(ChatColor.GOLD + "House " + id);
            p.sendMessage(ChatColor.YELLOW + "Price: " + price);
            p.sendMessage(ChatColor.YELLOW + "Type: " + (rent ? "rent" : "buy"));
            p.sendMessage(ChatColor.YELLOW + "Owner: " + (owner == null ? "none" : Bukkit.getOfflinePlayer((UUID)UUID.fromString(owner)).getName()));
            p.sendMessage(ChatColor.YELLOW + "Doors: " + cfg.getStringList(path + ".doors").size());
            p.sendMessage(ChatColor.YELLOW + "Trusted: " + String.join((CharSequence)", ", this.getTrustedNames(cfg.getStringList(path + ".trusted"))));
            return true;
        }
        if (args[0].equalsIgnoreCase("trust") || args[0].equalsIgnoreCase("untrust")) {
            int id;
            if (args.length < 3) {
                p.sendMessage(ChatColor.RED + "/houses " + args[0].toLowerCase() + " <id> <player>");
                return true;
            }
            try {
                id = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ex) {
                p.sendMessage(ChatColor.RED + "Invalid id");
                return true;
            }
            String path = "houses." + id;
            if (!cfg.isConfigurationSection(path)) {
                p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "Unknown house");
                return true;
            }
            String owner = cfg.getString(path + ".owner");
            if (owner == null || !owner.equals(p.getUniqueId().toString())) {
                p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "Not owner");
                return true;
            }
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[2]);
            if (args[0].equalsIgnoreCase("trust")) {
                this.plugin.addTrusted(id, target.getUniqueId());
                p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.GREEN + "Trusted " + target.getName());
            } else {
                this.plugin.removeTrusted(id, target.getUniqueId());
                p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.GREEN + "Untrusted " + target.getName());
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("market")) {
            this.plugin.openMarket(p, MinecraftHouses.MarketFilter.ALL);
            return true;
        }
        if (args[0].equalsIgnoreCase("adddoor")) {
            int id;
            if (!p.hasPermission("houses.admin")) {
                p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "No permission");
                return true;
            }
            if (args.length < 2) {
                p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "/houses adddoor <id>");
                return true;
            }
            try {
                id = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ex) {
                p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "Invalid id");
                return true;
            }
            this.plugin.awaitingDoorAdd.put(p.getUniqueId(), id);
            this.plugin.awaitingDoorRemove.remove(p.getUniqueId());
            p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.GREEN + "Right click a door to add to house " + id);
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!p.hasPermission("houses.admin")) {
                p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "No permission");
                return true;
            }
            this.plugin.reloadPlugin();
            p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.GREEN + "Plugin reloaded");
            return true;
        }
        p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.RED + "Unknown subcommand");
        return true;
    }

    private void sendHelp(Player p) {
        p.sendMessage(ChatColor.YELLOW + "[Houses]" + ChatColor.GREEN + " Available commands:");
        p.sendMessage(ChatColor.AQUA + "/houses list" + ChatColor.GRAY + " - list all houses");
        p.sendMessage(ChatColor.AQUA + "/houses owned" + ChatColor.GRAY + " - your houses");
        p.sendMessage(ChatColor.AQUA + "/houses info <id>" + ChatColor.GRAY + " - house info");
        p.sendMessage(ChatColor.AQUA + "/houses trust <id> <player>" + ChatColor.GRAY + " - trust player");
        p.sendMessage(ChatColor.AQUA + "/houses untrust <id> <player>" + ChatColor.GRAY + " - untrust player");
        p.sendMessage(ChatColor.AQUA + "/houses market" + ChatColor.GRAY + " - open market GUI");
        if (p.hasPermission("houses.admin")) {
            p.sendMessage(ChatColor.AQUA + "/houses adddoor <id>" + ChatColor.GRAY + " - add a door to a house");
            p.sendMessage(ChatColor.AQUA + "/houses reload" + ChatColor.GRAY + " - reload configs");
        }
    }

    private List<String> getTrustedNames(List<String> uuids) {
        ArrayList<String> names = new ArrayList<String>();
        for (String u : uuids) {
            try {
                names.add(Bukkit.getOfflinePlayer((UUID)UUID.fromString(u)).getName());
            }
            catch (Exception exception) {}
        }
        return names;
    }
}

