/*
 * Decompiled with CFR 0.152.
 */
package com.alphactx;

import com.alphactx.HousesCommand;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class MinecraftHouses
extends JavaPlugin
implements Listener {
    private Economy economy;
    private File housesFile;
    private FileConfiguration housesConfig;
    public final Map<UUID, Integer> awaitingDoorAdd = new HashMap<UUID, Integer>();
    public final Map<UUID, Integer> awaitingDoorRemove = new HashMap<UUID, Integer>();
    private final Map<UUID, MarketFilter> marketFilters = new HashMap<UUID, MarketFilter>();
    private final Map<UUID, Integer> marketPages = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> confirmBuy = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> confirmSell = new HashMap<UUID, Integer>();

    public void onEnable() {
        if (!this.setupEconomy()) {
            this.getLogger().severe("Vault not found. Disabling.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.loadHouses();
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand("houses")).setExecutor((CommandExecutor)new HousesCommand(this));
        this.getLogger().info("  \u00e2\u2022\u00ad\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u2022\u00ae");
        this.getLogger().info("  \u00e2\u201d\u201a      AlphaCTX's       \u00e2\u201d\u201a");
        this.getLogger().info("  \u00e2\u201d\u201a        Houses         \u00e2\u201d\u201a");
        this.getLogger().info("  \u00e2\u201d\u201a         Plugin        \u00e2\u201d\u201a");
        this.getLogger().info("  \u00e2\u2022\u00b0\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u201d\u20ac\u00e2\u2022\u00af");
        this.getLogger().info("        Houses Enabled!");
    }

    public void onDisable() {
        this.saveHouses();
        this.getLogger().info("Houses Disabled!");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    private void loadHouses() {
        this.housesFile = new File(this.getDataFolder(), "houses.yml");
        if (!this.housesFile.exists()) {
            try {
                this.housesFile.getParentFile().mkdirs();
                this.housesFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.housesConfig = YamlConfiguration.loadConfiguration((File)this.housesFile);
    }

    public void reloadPlugin() {
        this.reloadConfig();
        this.loadHouses();
    }

    public void saveHouses() {
        try {
            this.housesConfig.save(this.housesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getHousesConfig() {
        return this.housesConfig;
    }

    private void sendConfiguredMessage(Player player, String key, int id) {
        String msg = this.getConfig().getString("messages." + key);
        if (msg != null) {
            msg = msg.replace("{id}", String.valueOf(id));
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
        }
    }

    @EventHandler
    public void onSignChange(SignChangeEvent e) {
        if (!e.getPlayer().hasPermission("houses.admin")) {
            return;
        }
        String line0 = ChatColor.stripColor((String)e.getLine(0));
        if ("[House]".equalsIgnoreCase(line0)) {
            this.createHouseSign(e, false);
        } else if ("[Rent]".equalsIgnoreCase(line0)) {
            this.createHouseSign(e, true);
        }
    }

    private void createHouseSign(SignChangeEvent e, boolean rent) {
        String priceLine = e.getLine(1);
        double price = 0.0;
        try {
            price = Double.parseDouble(priceLine);
        }
        catch (Exception ex) {
            e.getPlayer().sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.RED) + "Invalid price");
            return;
        }
        if (price <= 0.0) {
            e.getPlayer().sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.RED) + "Price must be positive");
            return;
        }
        int id = this.housesConfig.getInt("lastId", 0) + 1;
        this.housesConfig.set("lastId", (Object)id);
        String path = "houses." + id;
        this.housesConfig.set(path + ".rent", (Object)rent);
        this.housesConfig.set(path + ".price", (Object)price);
        this.housesConfig.set(path + ".owner", null);
        Block b = e.getBlock();
        this.housesConfig.set(path + ".world", (Object)b.getWorld().getName());
        this.housesConfig.set(path + ".x", (Object)b.getX());
        this.housesConfig.set(path + ".y", (Object)b.getY());
        this.housesConfig.set(path + ".z", (Object)b.getZ());
        this.saveHouses();
        e.setLine(0, String.valueOf(ChatColor.GREEN) + (rent ? "[Rent]" : "[House]"));
        e.setLine(1, priceLine);
        e.setLine(2, "");
        e.setLine(3, "id:" + id);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInteract(PlayerInteractEvent e) {
        int id;
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = e.getClickedBlock();
        if (block == null) {
            return;
        }
        Player p = e.getPlayer();
        Material type = block.getType();
        if (this.isDoor(type)) {
            UUID uid = p.getUniqueId();
            if (this.awaitingDoorAdd.containsKey(uid)) {
                int id2 = this.awaitingDoorAdd.remove(uid);
                this.addDoorToHouse(id2, block);
                p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.GREEN) + "Door added to house " + id2);
                e.setCancelled(true);
                return;
            }
            if (this.awaitingDoorRemove.containsKey(uid)) {
                int id3 = this.awaitingDoorRemove.remove(uid);
                this.removeDoorFromHouse(id3, block);
                p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.GREEN) + "Door removed from house " + id3);
                e.setCancelled(true);
                return;
            }
            int doorHouse = this.getHouseIdByDoor(block);
            if (doorHouse != -1) {
                String owner = this.housesConfig.getString("houses." + doorHouse + ".owner");
                boolean trusted = this.isTrusted(doorHouse, uid);
                if (owner == null || !owner.equals(uid.toString()) && !trusted) {
                    this.sendConfiguredMessage(p, "door-locked", doorHouse);
                    e.setCancelled(true);
                    return;
                }
            }
        }
        if (!this.isSign(type)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        String line0 = ChatColor.stripColor((String)sign.getLine(0));
        if (!line0.equalsIgnoreCase("[House]") && !line0.equalsIgnoreCase("[Rent]")) {
            return;
        }
        String idPart = ChatColor.stripColor((String)sign.getLine(3));
        if (!idPart.startsWith("id:")) {
            return;
        }
        try {
            id = Integer.parseInt(idPart.substring(3));
        }
        catch (Exception ex) {
            return;
        }
        String path = "houses." + id;
        boolean rent = this.housesConfig.getBoolean(path + ".rent");
        double price = this.housesConfig.getDouble(path + ".price");
        String owner = this.housesConfig.getString(path + ".owner");
        if (owner == null) {
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + (rent ? "Rent" : "Buy") + " price: " + price);
            if (p.isSneaking()) {
                int max = this.getConfig().getInt("max-houses-per-player", 0);
                if (max > 0) {
                    int owned = 0;
                    if (this.housesConfig.isConfigurationSection("houses")) {
                        for (String hid : this.housesConfig.getConfigurationSection("houses").getKeys(false)) {
                            if (!p.getUniqueId().toString().equals(this.housesConfig.getString("houses." + hid + ".owner"))) continue;
                            ++owned;
                        }
                    }
                    if (owned >= max) {
                        p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.RED) + "You have reached the house limit of " + max);
                        return;
                    }
                }
                if (this.economy.getBalance((OfflinePlayer)p) >= price) {
                    this.economy.withdrawPlayer((OfflinePlayer)p, price);
                    this.housesConfig.set(path + ".owner", (Object)p.getUniqueId().toString());
                    this.saveHouses();
                    sign.setLine(2, p.getName());
                    sign.update();
                    this.sendConfiguredMessage(p, rent ? "rent-success" : "buy-success", id);
                } else {
                    p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.RED) + "Not enough money");
                }
            } else {
                p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.GRAY) + "Sneak and right click to confirm");
            }
        } else if (owner.equals(p.getUniqueId().toString())) {
            double sellPrice = price * 0.75;
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Sell price: " + sellPrice);
            if (p.isSneaking()) {
                this.economy.depositPlayer((OfflinePlayer)p, sellPrice);
                this.housesConfig.set(path + ".owner", null);
                this.saveHouses();
                sign.setLine(2, "");
                sign.update();
                this.sendConfiguredMessage(p, rent ? "stop-rent-success" : "sell-success", id);
            } else {
                p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.GRAY) + "Sneak and right click to confirm sale");
            }
        } else {
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.RED) + "Someone else owns this.");
        }
    }

    private boolean isDoor(Material m) {
        return m.name().endsWith("_DOOR");
    }

    private boolean isSign(Material m) {
        String name = m.name();
        return name.endsWith("_SIGN") || name.endsWith("_WALL_SIGN");
    }

    private String serialize(Block b) {
        return b.getWorld().getName() + "," + b.getX() + "," + b.getY() + "," + b.getZ();
    }

    private void addDoorToHouse(int id, Block door) {
        String ser;
        String path = "houses." + id + ".doors";
        List doors = this.housesConfig.getStringList(path);
        if (!doors.contains(ser = this.serialize(door))) {
            doors.add(ser);
            this.housesConfig.set(path, (Object)doors);
            this.saveHouses();
        }
    }

    private void removeDoorFromHouse(int id, Block door) {
        String ser;
        String path = "houses." + id + ".doors";
        List doors = this.housesConfig.getStringList(path);
        if (doors.remove(ser = this.serialize(door))) {
            this.housesConfig.set(path, (Object)doors);
            this.saveHouses();
        }
    }

    private List<String> getTrusted(int id) {
        return new ArrayList<String>(this.housesConfig.getStringList("houses." + id + ".trusted"));
    }

    private boolean isTrusted(int id, UUID uuid) {
        return this.getTrusted(id).contains(uuid.toString());
    }

    public void addTrusted(int id, UUID uuid) {
        String s;
        List<String> list = this.getTrusted(id);
        if (!list.contains(s = uuid.toString())) {
            list.add(s);
            this.housesConfig.set("houses." + id + ".trusted", list);
            this.saveHouses();
        }
    }

    public void removeTrusted(int id, UUID uuid) {
        List<String> list = this.getTrusted(id);
        if (list.remove(uuid.toString())) {
            this.housesConfig.set("houses." + id + ".trusted", list);
            this.saveHouses();
        }
    }

    private int getHouseIdByDoor(Block b) {
        if (!this.housesConfig.isConfigurationSection("houses")) {
            return -1;
        }
        String serClicked = this.serialize(b);
        String serOther = null;
        BlockData data = b.getBlockData();
        if (data instanceof Bisected) {
            Bisected bisected = (Bisected)data;
            Block other = bisected.getHalf() == Bisected.Half.TOP ? b.getRelative(BlockFace.DOWN) : b.getRelative(BlockFace.UP);
            serOther = this.serialize(other);
        }
        for (String idStr : this.housesConfig.getConfigurationSection("houses").getKeys(false)) {
            List doors = this.housesConfig.getStringList("houses." + idStr + ".doors");
            if (!doors.contains(serClicked) && (serOther == null || !doors.contains(serOther))) continue;
            try {
                return Integer.parseInt(idStr);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return -1;
    }

    private void updateHouseSign(int id, String ownerName) {
        String path = "houses." + id + ".";
        String world = this.housesConfig.getString(path + "world");
        if (world == null) {
            return;
        }
        Block b = Bukkit.getWorld((String)world).getBlockAt(this.housesConfig.getInt(path + "x"), this.housesConfig.getInt(path + "y"), this.housesConfig.getInt(path + "z"));
        if (b.getState() instanceof Sign) {
            Sign sign = (Sign)b.getState();
            sign.setLine(2, ownerName == null ? "" : ownerName);
            sign.update();
        }
    }

    private void buyHouse(Player p, int id) {
        String path = "houses." + id;
        boolean rent = this.housesConfig.getBoolean(path + ".rent");
        double price = this.housesConfig.getDouble(path + ".price");
        int max = this.getConfig().getInt("max-houses-per-player", 0);
        if (max > 0) {
            int owned = 0;
            if (this.housesConfig.isConfigurationSection("houses")) {
                for (String hid : this.housesConfig.getConfigurationSection("houses").getKeys(false)) {
                    if (!p.getUniqueId().toString().equals(this.housesConfig.getString("houses." + hid + ".owner"))) continue;
                    ++owned;
                }
            }
            if (owned >= max) {
                p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.RED) + "You have reached the house limit of " + max);
                return;
            }
        }
        if (this.economy.getBalance((OfflinePlayer)p) >= price) {
            this.economy.withdrawPlayer((OfflinePlayer)p, price);
            this.housesConfig.set(path + ".owner", (Object)p.getUniqueId().toString());
            this.housesConfig.set(path + ".trusted", new ArrayList());
            this.saveHouses();
            this.updateHouseSign(id, p.getName());
            this.sendConfiguredMessage(p, rent ? "rent-success" : "buy-success", id);
        } else {
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.RED) + "Not enough money");
        }
    }

    private void sellHouse(Player p, int id) {
        String path = "houses." + id;
        boolean rent = this.housesConfig.getBoolean(path + ".rent");
        double price = this.housesConfig.getDouble(path + ".price");
        double sellPrice = price * 0.75;
        this.economy.depositPlayer((OfflinePlayer)p, sellPrice);
        this.housesConfig.set(path + ".owner", null);
        this.housesConfig.set(path + ".trusted", new ArrayList());
        this.saveHouses();
        this.updateHouseSign(id, null);
        this.sendConfiguredMessage(p, rent ? "stop-rent-success" : "sell-success", id);
    }

    private void teleportToHouse(Player p, int id) {
        String path = "houses." + id + ".";
        String world = this.housesConfig.getString(path + "world");
        if (world == null) {
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.RED) + "Location not found");
            return;
        }
        int x = this.housesConfig.getInt(path + "x");
        int y = this.housesConfig.getInt(path + "y");
        int z = this.housesConfig.getInt(path + "z");
        p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.GREEN) + "Teleporting in 5 seconds...");
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            if (p.isOnline()) {
                p.teleport(new Location(Bukkit.getWorld((String)world), (double)x, (double)y, (double)z));
            }
        }, 100L);
    }

    public void openMarket(Player p, MarketFilter filter) {
        this.openMarket(p, filter, 0);
    }

    public void openMarket(Player p, MarketFilter filter, int page) {
        this.marketFilters.put(p.getUniqueId(), filter);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (this.housesConfig.isConfigurationSection("houses")) {
            for (String idStr : this.housesConfig.getConfigurationSection("houses").getKeys(false)) {
                String owner = this.housesConfig.getString("houses." + idStr + ".owner");
                int id = Integer.parseInt(idStr);
                if (filter == MarketFilter.AVAILABLE && owner != null || filter == MarketFilter.OWNED && !p.getUniqueId().toString().equals(owner)) continue;
                ids.add(id);
            }
        }
        int pages = Math.max(1, (ids.size() + 26) / 27);
        if (page < 0) {
            page = 0;
        }
        if (page >= pages) {
            page = pages - 1;
        }
        this.marketPages.put(p.getUniqueId(), page);
        Inventory inv = Bukkit.createInventory(null, (int)45, (String)"House Market");
        inv.setItem(0, this.createButton(Material.LIME_DYE, String.valueOf(ChatColor.GREEN) + "All"));
        inv.setItem(1, this.createButton(Material.BLUE_DYE, String.valueOf(ChatColor.BLUE) + "Available"));
        inv.setItem(2, this.createButton(Material.YELLOW_DYE, String.valueOf(ChatColor.YELLOW) + "Owned"));
        int start = page * 27;
        for (int i = 0; i < 27 && start + i < ids.size(); ++i) {
            int id = (Integer)ids.get(start + i);
            String path = "houses." + id;
            boolean rent = this.housesConfig.getBoolean(path + ".rent");
            double price = this.housesConfig.getDouble(path + ".price");
            ItemStack item = new ItemStack(rent ? Material.OAK_DOOR : Material.BRICKS);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.GOLD) + "House #" + id);
            meta.setLore(Arrays.asList(String.valueOf(ChatColor.YELLOW) + "Price: " + price, String.valueOf(ChatColor.GRAY) + (rent ? "Rent" : "Buy")));
            item.setItemMeta(meta);
            inv.setItem(9 + i, item);
        }
        if (page > 0) {
            inv.setItem(36, this.createButton(Material.ARROW, String.valueOf(ChatColor.YELLOW) + "Prev"));
        }
        inv.setItem(40, this.createButton(Material.PAPER, String.valueOf(ChatColor.YELLOW) + "Page " + (page + 1) + "/" + pages));
        if (page < pages - 1) {
            inv.setItem(44, this.createButton(Material.ARROW, String.valueOf(ChatColor.YELLOW) + "Next"));
        }
        p.openInventory(inv);
    }

    private ItemStack createButton(Material mat, String name) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    private void openHouseDetails(Player p, int id) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)("House #" + id));
        String path = "houses." + id;
        boolean rent = this.housesConfig.getBoolean(path + ".rent");
        double price = this.housesConfig.getDouble(path + ".price");
        String owner = this.housesConfig.getString(path + ".owner");
        ItemStack info = new ItemStack(Material.PAPER);
        ItemMeta meta = info.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.GOLD) + "House " + id);
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "Price: " + price)));
        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + (rent ? "Rent" : "Buy"))));
        lore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Owner: " + (owner == null ? "none" : Bukkit.getOfflinePlayer((UUID)UUID.fromString(owner)).getName()))));
        meta.setLore(lore);
        info.setItemMeta(meta);
        inv.setItem(11, info);
        ItemStack action = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta aMeta = action.getItemMeta();
        if (owner == null) {
            aMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + (rent ? "Rent" : "Buy"));
        } else if (owner.equals(p.getUniqueId().toString())) {
            aMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + (rent ? "Stop Rent" : "Sell"));
        } else {
            aMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Not yours");
        }
        action.setItemMeta(aMeta);
        inv.setItem(15, action);
        ItemStack tp = new ItemStack(Material.ENDER_PEARL);
        ItemMeta tMeta = tp.getItemMeta();
        tMeta.setDisplayName(String.valueOf(ChatColor.AQUA) + "Teleport");
        tp.setItemMeta(tMeta);
        inv.setItem(13, tp);
        inv.setItem(22, this.createButton(Material.ARROW, String.valueOf(ChatColor.RED) + "Back"));
        p.openInventory(inv);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        String title = e.getView().getTitle();
        if (title.equals("House Market")) {
            String name;
            ItemStack item;
            e.setCancelled(true);
            int slot = e.getRawSlot();
            if (slot == 0) {
                this.openMarket(p, MarketFilter.ALL, 0);
                return;
            }
            if (slot == 1) {
                this.openMarket(p, MarketFilter.AVAILABLE, 0);
                return;
            }
            if (slot == 2) {
                this.openMarket(p, MarketFilter.OWNED, 0);
                return;
            }
            MarketFilter filter = this.marketFilters.getOrDefault(p.getUniqueId(), MarketFilter.ALL);
            int page = this.marketPages.getOrDefault(p.getUniqueId(), 0);
            if (slot == 36) {
                this.openMarket(p, filter, page - 1);
                return;
            }
            if (slot == 44) {
                this.openMarket(p, filter, page + 1);
                return;
            }
            if (slot >= 9 && slot < 36 && (item = e.getCurrentItem()) != null && item.hasItemMeta() && (name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName())).startsWith("House #")) {
                int id = Integer.parseInt(name.substring(7));
                this.openHouseDetails(p, id);
            }
        } else if (title.startsWith("House #")) {
            e.setCancelled(true);
            int id = Integer.parseInt(title.substring(7));
            String path = "houses." + id;
            String owner = this.housesConfig.getString(path + ".owner");
            ItemStack item = e.getCurrentItem();
            if (item == null || !item.hasItemMeta()) {
                return;
            }
            String name = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
            if (name.equalsIgnoreCase("Buy") || name.equalsIgnoreCase("Rent")) {
                if (owner == null) {
                    if (!this.confirmBuy.containsKey(p.getUniqueId()) || this.confirmBuy.get(p.getUniqueId()) != id) {
                        this.confirmBuy.put(p.getUniqueId(), id);
                        p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.GREEN) + "Click again to confirm purchase.");
                    } else {
                        this.confirmBuy.remove(p.getUniqueId());
                        this.buyHouse(p, id);
                        p.closeInventory();
                    }
                }
            } else if (name.equalsIgnoreCase("Sell") || name.equalsIgnoreCase("Stop Rent")) {
                if (owner != null && owner.equals(p.getUniqueId().toString())) {
                    if (!this.confirmSell.containsKey(p.getUniqueId()) || this.confirmSell.get(p.getUniqueId()) != id) {
                        this.confirmSell.put(p.getUniqueId(), id);
                        p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.GREEN) + "Click again to confirm sale.");
                    } else {
                        this.confirmSell.remove(p.getUniqueId());
                        this.sellHouse(p, id);
                        p.closeInventory();
                    }
                }
            } else if (name.equalsIgnoreCase("Teleport")) {
                p.closeInventory();
                this.teleportToHouse(p, id);
            } else if (name.equalsIgnoreCase("Back")) {
                MarketFilter filter = this.marketFilters.getOrDefault(p.getUniqueId(), MarketFilter.ALL);
                int page = this.marketPages.getOrDefault(p.getUniqueId(), 0);
                this.openMarket(p, filter, page);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        UUID uid = e.getPlayer().getUniqueId();
        this.confirmBuy.remove(uid);
        this.confirmSell.remove(uid);
    }

    public static enum MarketFilter {
        ALL,
        AVAILABLE,
        OWNED;

    }
}

