/*
 * Decompiled with CFR 0.152.
 */
package com.alphactx;

import com.alphactx.MinecraftHouses;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class HousesCommand
implements CommandExecutor {
    private final MinecraftHouses plugin;

    public HousesCommand(MinecraftHouses plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players");
            return true;
        }
        Player p = (Player)sender;
        FileConfiguration cfg = this.plugin.getHousesConfig();
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            this.sendHelp(p);
            return true;
        }
        if (args[0].equalsIgnoreCase("list")) {
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Houses:");
            if (cfg.isConfigurationSection("houses")) {
                for (String id : cfg.getConfigurationSection("houses").getKeys(false)) {
                    String owner = cfg.getString("houses." + id + ".owner");
                    p.sendMessage(String.valueOf(ChatColor.GRAY) + "#" + id + " owner:" + (owner == null ? "none" : owner));
                }
            } else {
                p.sendMessage(String.valueOf(ChatColor.GRAY) + "(none)");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("owned")) {
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Owned houses:");
            if (cfg.isConfigurationSection("houses")) {
                for (String id : cfg.getConfigurationSection("houses").getKeys(false)) {
                    String owner = cfg.getString("houses." + id + ".owner");
                    if (!p.getUniqueId().toString().equals(owner)) continue;
                    p.sendMessage(String.valueOf(ChatColor.GREEN) + "#" + id);
                }
            } else {
                p.sendMessage(String.valueOf(ChatColor.GRAY) + "(none)");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("info")) {
            int id;
            if (args.length < 2) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "/houses info <id>");
                return true;
            }
            try {
                id = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ex) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "Invalid id");
                return true;
            }
            if (!cfg.isConfigurationSection("houses." + id)) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "Unknown house");
                return true;
            }
            String path = "houses." + id;
            boolean rent = cfg.getBoolean(path + ".rent");
            double price = cfg.getDouble(path + ".price");
            String owner = cfg.getString(path + ".owner");
            p.sendMessage(String.valueOf(ChatColor.GOLD) + "House " + id);
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Price: " + price);
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Type: " + (rent ? "rent" : "buy"));
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Owner: " + (owner == null ? "none" : Bukkit.getOfflinePlayer((UUID)UUID.fromString(owner)).getName()));
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Doors: " + cfg.getStringList(path + ".doors").size());
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "Trusted: " + String.join((CharSequence)", ", this.getTrustedNames(cfg.getStringList(path + ".trusted"))));
            return true;
        }
        if (args[0].equalsIgnoreCase("trust") || args[0].equalsIgnoreCase("untrust")) {
            int id;
            if (args.length < 3) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "/houses " + args[0].toLowerCase() + " <id> <player>");
                return true;
            }
            try {
                id = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ex) {
                p.sendMessage(String.valueOf(ChatColor.RED) + "Invalid id");
                return true;
            }
            String path = "houses." + id;
            if (!cfg.isConfigurationSection(path)) {
                p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.RED) + "Unknown house");
                return true;
            }
            String owner = cfg.getString(path + ".owner");
            if (owner == null || !owner.equals(p.getUniqueId().toString())) {
                p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.RED) + "Not owner");
                return true;
            }
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[2]);
            if (args[0].equalsIgnoreCase("trust")) {
                this.plugin.addTrusted(id, target.getUniqueId());
                p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.GREEN) + "Trusted " + target.getName());
            } else {
                this.plugin.removeTrusted(id, target.getUniqueId());
                p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.GREEN) + "Untrusted " + target.getName());
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("market")) {
            this.plugin.openMarket(p, MinecraftHouses.MarketFilter.ALL);
            return true;
        }
        if (args[0].equalsIgnoreCase("adddoor")) {
            int id;
            if (!p.hasPermission("houses.admin")) {
                p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.RED) + "No permission");
                return true;
            }
            if (args.length < 2) {
                p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.RED) + "/houses adddoor <id>");
                return true;
            }
            try {
                id = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ex) {
                p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.RED) + "Invalid id");
                return true;
            }
            this.plugin.awaitingDoorAdd.put(p.getUniqueId(), id);
            this.plugin.awaitingDoorRemove.remove(p.getUniqueId());
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.GREEN) + "Right click a door to add to house " + id);
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!p.hasPermission("houses.admin")) {
                p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.RED) + "No permission");
                return true;
            }
            this.plugin.reloadPlugin();
            p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.GREEN) + "Plugin reloaded");
            return true;
        }
        p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.RED) + "Unknown subcommand");
        return true;
    }

    private void sendHelp(Player p) {
        p.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Houses]" + String.valueOf(ChatColor.GREEN) + " Available commands:");
        p.sendMessage(String.valueOf(ChatColor.AQUA) + "/houses list" + String.valueOf(ChatColor.GRAY) + " - list all houses");
        p.sendMessage(String.valueOf(ChatColor.AQUA) + "/houses owned" + String.valueOf(ChatColor.GRAY) + " - your houses");
        p.sendMessage(String.valueOf(ChatColor.AQUA) + "/houses info <id>" + String.valueOf(ChatColor.GRAY) + " - house info");
        p.sendMessage(String.valueOf(ChatColor.AQUA) + "/houses trust <id> <player>" + String.valueOf(ChatColor.GRAY) + " - trust player");
        p.sendMessage(String.valueOf(ChatColor.AQUA) + "/houses untrust <id> <player>" + String.valueOf(ChatColor.GRAY) + " - untrust player");
        p.sendMessage(String.valueOf(ChatColor.AQUA) + "/houses market" + String.valueOf(ChatColor.GRAY) + " - open market GUI");
        if (p.hasPermission("houses.admin")) {
            p.sendMessage(String.valueOf(ChatColor.AQUA) + "/houses adddoor <id>" + String.valueOf(ChatColor.GRAY) + " - add a door to a house");
            p.sendMessage(String.valueOf(ChatColor.AQUA) + "/houses reload" + String.valueOf(ChatColor.GRAY) + " - reload configs");
        }
    }

    private List<String> getTrustedNames(List<String> uuids) {
        ArrayList<String> names = new ArrayList<String>();
        for (String u : uuids) {
            try {
                names.add(Bukkit.getOfflinePlayer((UUID)UUID.fromString(u)).getName());
            }
            catch (Exception exception) {}
        }
        return names;
    }
}

