/*
 * Decompiled with CFR 0.152.
 */
package com.alphactx.model;

import com.alphactx.model.ChallengeType;
import com.alphactx.model.ScoreField;
import com.alphactx.model.Skill;
import com.alphactx.model.Stats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class PlayerData {
    private final UUID uuid;
    private int level = 1;
    private int xp = 0;
    private int skillPoints = 0;
    private long lastJoin;
    private final Stats stats = new Stats();
    private final Map<Skill, Integer> skills = new EnumMap<Skill, Integer>(Skill.class);
    private final Map<ChallengeType, Double> dailyProgress = new EnumMap<ChallengeType, Double>(ChallengeType.class);
    private final Map<ChallengeType, Double> weeklyProgress = new EnumMap<ChallengeType, Double>(ChallengeType.class);
    private long lastDailyReset = System.currentTimeMillis();
    private long lastWeeklyReset = System.currentTimeMillis();
    private boolean scoreboardEnabled = false;
    private boolean showBalance = false;
    private double lastBalance = 0.0;
    private final List<ScoreField> boardOrder = new ArrayList<ScoreField>();
    private final Map<ScoreField, Boolean> boardEnabled = new EnumMap<ScoreField, Boolean>(ScoreField.class);

    public PlayerData(UUID uuid) {
        this.uuid = uuid;
        for (Skill skill : Skill.values()) {
            this.skills.put(skill, 0);
        }
        for (Enum enum_ : ChallengeType.values()) {
            this.dailyProgress.put((ChallengeType)enum_, 0.0);
            this.weeklyProgress.put((ChallengeType)enum_, 0.0);
        }
        this.boardOrder.addAll(Arrays.asList(ScoreField.LEVEL, ScoreField.XP, ScoreField.PROGRESS, ScoreField.BALANCE, ScoreField.KILLS, ScoreField.MOB_KILLS, ScoreField.DEATHS, ScoreField.KM));
        for (Enum enum_ : ScoreField.values()) {
            boolean def = enum_ == ScoreField.LEVEL || enum_ == ScoreField.XP || enum_ == ScoreField.PROGRESS;
            this.boardEnabled.put((ScoreField)enum_, def);
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getLevel() {
        return this.level;
    }

    public int getXp() {
        return this.xp;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setXp(int xp) {
        this.xp = xp;
    }

    public int getSkillPoints() {
        return this.skillPoints;
    }

    public Stats getStats() {
        return this.stats;
    }

    public void setLastJoin(long time) {
        this.lastJoin = time;
    }

    public long getLastJoin() {
        return this.lastJoin;
    }

    public int getSkillLevel(Skill skill) {
        return this.skills.getOrDefault((Object)skill, 0);
    }

    public void setSkillLevel(Skill skill, int level) {
        this.skills.put(skill, level);
    }

    public Map<Skill, Integer> getSkills() {
        return new EnumMap<Skill, Integer>(this.skills);
    }

    public void levelSkill(Skill skill) {
        if (this.skillPoints > 0) {
            this.skills.put(skill, this.getSkillLevel(skill) + 1);
            --this.skillPoints;
        }
    }

    public void addXp(int amount) {
        this.xp += amount;
    }

    public boolean tryLevelUp() {
        int needed = this.level * 100;
        boolean leveled = false;
        while (this.xp >= needed) {
            this.xp -= needed;
            ++this.level;
            this.skillPoints += this.level % 5 == 0 ? 1 : 0;
            leveled = true;
            needed = this.level * 100;
        }
        return leveled;
    }

    public void addSkillPoints(int amount) {
        this.skillPoints += amount;
    }

    public void setSkillPoints(int amount) {
        this.skillPoints = amount;
    }

    public Map<ChallengeType, Double> getDailyProgress() {
        return this.dailyProgress;
    }

    public Map<ChallengeType, Double> getWeeklyProgress() {
        return this.weeklyProgress;
    }

    public void addDailyProgress(ChallengeType type, double amount) {
        this.dailyProgress.put(type, this.dailyProgress.getOrDefault((Object)type, 0.0) + amount);
    }

    public void addWeeklyProgress(ChallengeType type, double amount) {
        this.weeklyProgress.put(type, this.weeklyProgress.getOrDefault((Object)type, 0.0) + amount);
    }

    public long getLastDailyReset() {
        return this.lastDailyReset;
    }

    public void setLastDailyReset(long time) {
        this.lastDailyReset = time;
        this.dailyProgress.replaceAll((t, v) -> 0.0);
    }

    public void loadLastDailyReset(long time) {
        this.lastDailyReset = time;
    }

    public long getLastWeeklyReset() {
        return this.lastWeeklyReset;
    }

    public void setLastWeeklyReset(long time) {
        this.lastWeeklyReset = time;
        this.weeklyProgress.replaceAll((t, v) -> 0.0);
    }

    public void loadLastWeeklyReset(long time) {
        this.lastWeeklyReset = time;
    }

    public boolean isScoreboardEnabled() {
        return this.scoreboardEnabled;
    }

    public void setScoreboardEnabled(boolean enabled) {
        this.scoreboardEnabled = enabled;
    }

    public boolean isShowBalance() {
        return this.showBalance;
    }

    public void setShowBalance(boolean showBalance) {
        this.showBalance = showBalance;
    }

    public double getLastBalance() {
        return this.lastBalance;
    }

    public void setLastBalance(double lastBalance) {
        this.lastBalance = lastBalance;
    }

    public List<ScoreField> getBoardOrder() {
        return this.boardOrder;
    }

    public boolean isFieldEnabled(ScoreField field) {
        return this.boardEnabled.getOrDefault((Object)field, false);
    }

    public void setFieldEnabled(ScoreField field, boolean enabled) {
        this.boardEnabled.put(field, enabled);
    }
}

