/*
 * Decompiled with CFR 0.152.
 */
package com.alphactx.storage;

import com.alphactx.model.PlayerData;
import com.alphactx.storage.DataStorage;
import com.alphactx.storage.DataUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MySqlStorage
implements DataStorage {
    private final Connection connection;

    public MySqlStorage(String host, int port, String db, String user, String pass) throws SQLException {
        String url = "jdbc:mysql://" + host + ":" + port + "/" + db + "?useSSL=false";
        this.connection = DriverManager.getConnection(url, user, pass);
        try (Statement st = this.connection.createStatement();){
            st.executeUpdate("CREATE TABLE IF NOT EXISTS players (uuid VARCHAR(36) PRIMARY KEY, data TEXT)");
        }
    }

    @Override
    public void load(Map<UUID, PlayerData> target) throws SQLException {
        try (Statement st = this.connection.createStatement();){
            ResultSet rs = st.executeQuery("SELECT uuid,data FROM players");
            while (rs.next()) {
                UUID id = UUID.fromString(rs.getString(1));
                String yaml = rs.getString(2);
                YamlConfiguration cfg = new YamlConfiguration();
                try {
                    cfg.loadFromString(yaml);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PlayerData data = new PlayerData(id);
                DataUtil.load((FileConfiguration)cfg, data);
                target.put(id, data);
            }
        }
    }

    @Override
    public void save(Map<UUID, PlayerData> source) throws SQLException {
        try (PreparedStatement ps = this.connection.prepareStatement("REPLACE INTO players(uuid,data) VALUES(?,?)");){
            for (PlayerData data : source.values()) {
                YamlConfiguration cfg = new YamlConfiguration();
                DataUtil.save((FileConfiguration)cfg, data);
                ps.setString(1, data.getUuid().toString());
                ps.setString(2, cfg.saveToString());
                ps.executeUpdate();
            }
        }
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }
}

