/*
 * Decompiled with CFR 0.152.
 */
package com.alphactx;

import com.alphactx.model.ChallengeType;
import com.alphactx.model.PlayerData;
import com.alphactx.model.ScoreField;
import com.alphactx.model.Skill;
import com.alphactx.model.Stats;
import com.alphactx.storage.DataStorage;
import com.alphactx.storage.MySqlStorage;
import com.alphactx.storage.SqliteStorage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class LevelsX
extends JavaPlugin
implements Listener,
TabCompleter {
    private final Map<UUID, PlayerData> players = new HashMap<UUID, PlayerData>();
    private final Map<ChallengeType, Double> dailyGoals = new EnumMap<ChallengeType, Double>(ChallengeType.class);
    private final Map<ChallengeType, Double> weeklyGoals = new EnumMap<ChallengeType, Double>(ChallengeType.class);
    private final List<ChallengeType> activeDaily = new ArrayList<ChallengeType>();
    private final List<ChallengeType> activeWeekly = new ArrayList<ChallengeType>();
    private long lastDailySelect;
    private long lastWeeklySelect;
    private ScoreboardManager scoreboardManager;
    private Economy economy;
    private final Map<UUID, Integer> pendingRewardLevel = new HashMap<UUID, Integer>();
    private int levelCap;
    private DataStorage storage;
    private int autosaveTask = -1;

    private void initChallenges() {
        FileConfiguration cfg = this.getConfig();
        for (ChallengeType type : ChallengeType.values()) {
            this.dailyGoals.put(type, cfg.getDouble("dailyGoals." + type.name(), this.getDefaultGoal(type)));
            this.weeklyGoals.put(type, cfg.getDouble("weeklyGoals." + type.name(), this.getDefaultGoal(type) * 5.0));
        }
    }

    private double getDefaultGoal(ChallengeType type) {
        switch (type) {
            case MOB_KILLS: {
                return 10.0;
            }
            case DAMAGE_TAKEN: {
                return 500.0;
            }
            case MONEY_EARNED: 
            case MONEY_SPENT: {
                return 1000.0;
            }
            case KILOMETERS_TRAVELED: {
                return 5.0;
            }
        }
        return 0.0;
    }

    private void selectDailyChallenges() {
        this.activeDaily.clear();
        ArrayList<ChallengeType> list = new ArrayList<ChallengeType>(Arrays.asList(ChallengeType.values()));
        Collections.shuffle(list);
        for (int i = 0; i < 3 && i < list.size(); ++i) {
            this.activeDaily.add((ChallengeType)((Object)list.get(i)));
        }
    }

    private void selectWeeklyChallenges() {
        this.activeWeekly.clear();
        ArrayList<ChallengeType> list = new ArrayList<ChallengeType>(Arrays.asList(ChallengeType.values()));
        Collections.shuffle(list);
        for (int i = 0; i < 3 && i < list.size(); ++i) {
            this.activeWeekly.add((ChallengeType)((Object)list.get(i)));
        }
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.scoreboardManager = Bukkit.getScoreboardManager();
        this.levelCap = Math.min(1000, Math.max(1, this.getConfig().getInt("levelCap", 100)));
        this.setupStorage();
        if (!this.setupEconomy()) {
            this.getLogger().severe("Vault dependency not found");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.initChallenges();
        this.selectDailyChallenges();
        this.selectWeeklyChallenges();
        this.lastDailySelect = this.lastWeeklySelect = System.currentTimeMillis();
        this.loadData();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand("skill")).setTabCompleter((TabCompleter)this);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, this::checkBalances, 20L, 20L);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, this::checkChallengeResets, 72000L, 72000L);
        int minutes = Math.max(1, this.getConfig().getInt("autosave", 5));
        this.autosaveTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this::saveData, 1200L * (long)minutes, 1200L * (long)minutes);
        this.getLogger().info(" _         _    __  __");
        this.getLogger().info("| | __   _| |   \\ \\/ /");
        this.getLogger().info("| | \\ \\ / / |    \\  / ");
        this.getLogger().info("| |__\\ V /| |___ /  \\ ");
        this.getLogger().info("|_____\\_/ |_____/_/\\_\\");
        this.getLogger().info("         enabled");
    }

    public void onDisable() {
        this.checkBalances();
        this.saveData();
        if (this.autosaveTask != -1) {
            Bukkit.getScheduler().cancelTask(this.autosaveTask);
        }
        try {
            if (this.storage != null) {
                this.storage.close();
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to close storage: " + e.getMessage());
        }
    }

    private PlayerData getData(UUID uuid) {
        return this.players.computeIfAbsent(uuid, PlayerData::new);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        PlayerData d = this.getData(p.getUniqueId());
        long now = System.currentTimeMillis();
        d.setLastJoin(now);
        d.setLastBalance(this.economy.getBalance((OfflinePlayer)p));
        if (now - d.getLastDailyReset() > 86400000L) {
            d.setLastDailyReset(now);
        }
        if (now - d.getLastWeeklyReset() > 604800000L) {
            d.setLastWeeklyReset(now);
        }
        this.updateLungCapacity(p, d);
        this.updateScoreboard(p);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        PlayerData d = this.getData(p.getUniqueId());
        long session = System.currentTimeMillis() - d.getLastJoin();
        d.getStats().addTimeOnline(session);
        double cur = this.economy.getBalance((OfflinePlayer)p);
        double diff = cur - d.getLastBalance();
        if (Math.abs(diff) > 0.01) {
            if (diff > 0.0) {
                d.getStats().addMoneyEarned(diff);
                this.addProgress(p, d, ChallengeType.MONEY_EARNED, diff);
            } else {
                diff = -diff;
                d.getStats().addMoneySpent(diff);
                this.addProgress(p, d, ChallengeType.MONEY_SPENT, diff);
            }
            d.setLastBalance(cur);
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent e) {
        if (e.getEntity().getKiller() == null) {
            return;
        }
        Player k = e.getEntity().getKiller();
        PlayerData d = this.getData(k.getUniqueId());
        int xp = 0;
        double money = 0.0;
        if (e.getEntityType() == EntityType.PLAYER) {
            d.getStats().addKill();
            xp = this.getConfig().getInt("killRewards.players.xp", 25);
            money = this.getConfig().getDouble("killRewards.players.money", 0.0);
        } else {
            d.getStats().addMobKill();
            xp = this.getConfig().getInt("killRewards.mobs.xp", 10);
            money = this.getConfig().getDouble("killRewards.mobs.money", 0.0);
            this.addProgress(k, d, ChallengeType.MOB_KILLS, 1.0);
        }
        this.applyHealing(k, d);
        if (xp > 0) {
            this.awardXp(k, xp);
        }
        if (money > 0.0) {
            this.economy.depositPlayer((OfflinePlayer)k, money);
            this.msg((CommandSender)k, "You earned $" + money);
            d.getStats().addMoneyEarned(money);
            d.setLastBalance(this.economy.getBalance((OfflinePlayer)k));
        }
        if (d.isScoreboardEnabled() && (d.isFieldEnabled(ScoreField.KILLS) || d.isFieldEnabled(ScoreField.MOB_KILLS))) {
            this.updateScoreboard(k);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        Player p = e.getEntity();
        PlayerData d = this.getData(p.getUniqueId());
        d.getStats().addDeath();
        if (d.isScoreboardEnabled() && d.isFieldEnabled(ScoreField.DEATHS)) {
            this.updateScoreboard(p);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent e) {
        if (e.getDamager() instanceof Player) {
            this.handlePlayerDamageDealt((Player)e.getDamager(), e);
        }
        if (e.getEntity() instanceof Player) {
            this.handlePlayerDamageTaken((Player)e.getEntity(), e);
        }
    }

    private void handlePlayerDamageDealt(Player p, EntityDamageByEntityEvent e) {
        PlayerData d = this.getData(p.getUniqueId());
        d.getStats().addDamageDealt(e.getDamage());
        int lvl = d.getSkillLevel(Skill.DAMAGE);
        if (lvl > 0) {
            e.setDamage(e.getDamage() * (1.0 + 0.05 * (double)lvl));
        }
        this.applyLifesteal(p, e, d);
    }

    private void applyLifesteal(Player p, EntityDamageByEntityEvent e, PlayerData d) {
        int lvl = d.getSkillLevel(Skill.LIFESTEAL);
        if (lvl > 0) {
            double heal = e.getDamage() * 0.05 * (double)lvl;
            p.setHealth(Math.min(p.getMaxHealth(), p.getHealth() + heal));
        }
    }

    private void handlePlayerDamageTaken(Player p, EntityDamageByEntityEvent e) {
        PlayerData d = this.getData(p.getUniqueId());
        d.getStats().addDamageTaken(e.getDamage());
        int lvl = d.getSkillLevel(Skill.DAMAGE_REDUCTION);
        if (lvl > 0) {
            e.setDamage(e.getDamage() * (1.0 - 0.05 * (double)lvl));
        }
        this.addProgress(p, d, ChallengeType.DAMAGE_TAKEN, e.getDamage());
    }

    @EventHandler
    public void onMove(PlayerMoveEvent e) {
        if (!e.getFrom().getWorld().equals(e.getTo().getWorld())) {
            return;
        }
        double dist = e.getFrom().distance(e.getTo());
        Player p = e.getPlayer();
        PlayerData d = this.getData(p.getUniqueId());
        double km = dist / 1000.0;
        d.getStats().addKilometersTraveled(km);
        this.addProgress(p, d, ChallengeType.KILOMETERS_TRAVELED, km);
        int xp = (int)Math.round(km * 5.0);
        if (xp > 0) {
            this.awardXp(p, xp);
        }
        if (d.isScoreboardEnabled() && d.isFieldEnabled(ScoreField.KM)) {
            this.updateScoreboard(p);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        int delta;
        boolean custom;
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        String title = e.getView().getTitle();
        boolean bl = custom = title.equals("Menu") || title.equals("Skills") || title.equals("Daily") || title.equals("Weekly") || title.equals("Stats") || title.equals("Config") || title.equals("Scoreboard") || title.equals("Admin Menu") || title.equals("Level Config") || title.equals("Challenge Config") || title.startsWith("Challenge ") || title.equals("Kill Config");
        if (!custom) {
            return;
        }
        boolean picking = this.pendingRewardLevel.containsKey(p.getUniqueId());
        if (!picking || e.getClickedInventory() != p.getInventory() || e.isShiftClick()) {
            e.setCancelled(true);
        }
        ClickType click = e.getClick();
        int slot = e.getRawSlot();
        if (title.equals("Menu")) {
            switch (slot) {
                case 0: {
                    this.openSkillGui(p);
                    break;
                }
                case 1: {
                    this.openDailyGui(p);
                    break;
                }
                case 2: {
                    this.openWeeklyGui(p);
                    break;
                }
                case 3: {
                    this.openStatsGui(p);
                    break;
                }
                case 4: {
                    this.openConfigGui(p);
                }
            }
            return;
        }
        if (title.equals("Skills")) {
            if (slot >= 0 && slot < Skill.values().length) {
                Skill s = Skill.values()[slot];
                PlayerData d = this.getData(p.getUniqueId());
                d.levelSkill(s);
                this.updateLungCapacity(p, d);
                this.openSkillGui(p);
            } else if (slot == 7) {
                this.openMainGui(p);
            }
            return;
        }
        if (title.equals("Admin Menu")) {
            switch (slot) {
                case 0: {
                    this.openLevelConfigGui(p);
                    break;
                }
                case 1: {
                    this.openChallengeConfigGui(p);
                    break;
                }
                case 2: {
                    this.openKillConfigGui(p);
                    break;
                }
                case 8: {
                    p.closeInventory();
                }
            }
            return;
        }
        if (title.equals("Level Config")) {
            int rewardSlots = this.levelCap / 20;
            int extra = 4;
            int moneySlot = (rewardSlots + extra + 8) / 9 * 9 - extra;
            int itemSlot = moneySlot + 1;
            int capSlot = moneySlot + 2;
            int backSlot = moneySlot + 3;
            if (this.pendingRewardLevel.containsKey(p.getUniqueId()) && e.getClickedInventory() == p.getInventory()) {
                ItemStack cur = e.getCurrentItem();
                if (cur != null && !cur.getType().isAir()) {
                    int lvl = this.pendingRewardLevel.remove(p.getUniqueId());
                    if (lvl == -1) {
                        this.getConfig().set("itemReward", (Object)cur.getType().name());
                    } else {
                        this.getConfig().set("itemRewards." + lvl, (Object)cur.getType().name());
                    }
                    this.saveConfig();
                    this.msg((CommandSender)p, "Set reward for " + (lvl == -1 ? "default" : "level " + lvl) + " to " + cur.getType());
                    this.openLevelConfigGui(p);
                }
                return;
            }
            if (slot < rewardSlots) {
                int lvl = (slot + 1) * 20;
                this.pendingRewardLevel.put(p.getUniqueId(), lvl);
                this.msg((CommandSender)p, "Klik een item in je inventory om reward voor level " + lvl + " in te stellen");
                return;
            }
            if (slot == moneySlot) {
                double m = this.getConfig().getDouble("moneyReward", 100.0);
                this.getConfig().set("moneyReward", (Object)Math.max(0.0, m += (double)((click == ClickType.RIGHT ? 1 : -1) * (click.isShiftClick() ? 10 : 1))));
                this.saveConfig();
                this.openLevelConfigGui(p);
                return;
            }
            if (slot == itemSlot) {
                this.pendingRewardLevel.put(p.getUniqueId(), -1);
                this.msg((CommandSender)p, "Klik een item in je inventory voor default reward");
                return;
            }
            if (slot == capSlot) {
                this.levelCap += click == ClickType.RIGHT ? 10 : -10;
                this.levelCap = Math.max(1, Math.min(1000, this.levelCap));
                this.getConfig().set("levelCap", (Object)this.levelCap);
                this.saveConfig();
                this.openLevelConfigGui(p);
                return;
            }
            if (slot == backSlot) {
                this.openAdminMenu(p);
                return;
            }
        }
        if (title.equals("Challenge Config")) {
            if (slot < ChallengeType.values().length) {
                this.openChallengeTypeGui(p, ChallengeType.values()[slot]);
            } else if (slot == 8) {
                this.openAdminMenu(p);
            }
            return;
        }
        if (title.startsWith("Challenge ")) {
            ChallengeType type = ChallengeType.valueOf(title.substring(10));
            String base = "challengeRewards.";
            if (slot >= 0 && slot <= 5) {
                int idx;
                String key = slot < 3 ? "daily" : "weekly";
                int n = delta = click.isShiftClick() ? 10 : 1;
                if (click == ClickType.LEFT) {
                    delta = -delta;
                }
                if ((idx = slot % 3) == 2) {
                    String path = key + "Goals." + type.name();
                    double v = Math.max(0.0, this.getConfig().getDouble(path) + (double)delta);
                    this.getConfig().set(path, (Object)v);
                    if (key.equals("daily")) {
                        this.dailyGoals.put(type, v);
                    } else {
                        this.weeklyGoals.put(type, v);
                    }
                } else {
                    String sub = idx == 0 ? "xp" : "money";
                    String path = base + key + ".types." + type.name() + "." + sub;
                    if (sub.equals("xp")) {
                        int v = Math.max(0, this.getConfig().getInt(path) + delta);
                        this.getConfig().set(path, (Object)v);
                    } else {
                        double v = Math.max(0.0, this.getConfig().getDouble(path) + (double)delta);
                        this.getConfig().set(path, (Object)v);
                    }
                }
                this.saveConfig();
                this.openChallengeTypeGui(p, type);
            } else if (slot == 8) {
                this.openChallengeConfigGui(p);
            }
            return;
        }
        if (title.equals("Kill Config")) {
            if (slot == 0 || slot == 1 || slot == 3 || slot == 4) {
                boolean isXP = slot == 0 || slot == 3;
                String path = slot < 2 ? "killRewards.players." : "killRewards.mobs.";
                String sub = isXP ? "xp" : "money";
                int n = delta = click.isShiftClick() ? 10 : 1;
                if (click == ClickType.LEFT) {
                    delta = -delta;
                }
                if (isXP) {
                    int v = Math.max(0, this.getConfig().getInt(path + sub) + delta);
                    this.getConfig().set(path + sub, (Object)v);
                } else {
                    double v = Math.max(0.0, this.getConfig().getDouble(path + sub) + (double)delta);
                    this.getConfig().set(path + sub, (Object)v);
                }
                this.saveConfig();
                this.openKillConfigGui(p);
            } else if (slot == 8) {
                this.openAdminMenu(p);
            }
            return;
        }
        if (title.equals("Stats")) {
            if (slot == 26) {
                this.openMainGui(p);
            }
            return;
        }
        if (title.equals("Daily")) {
            if (slot == 17) {
                this.openMainGui(p);
            }
            return;
        }
        if (title.equals("Weekly")) {
            if (slot == 17) {
                this.openMainGui(p);
            }
            return;
        }
        if (title.equals("Scoreboard")) {
            if (slot == e.getView().getTopInventory().getSize() - 1) {
                this.openConfigGui(p);
                return;
            }
            int idx = slot;
            PlayerData d = this.getData(p.getUniqueId());
            if (idx < d.getBoardOrder().size()) {
                if (e.isShiftClick()) {
                    int dir = e.isLeftClick() ? -1 : 1;
                    int tgt = idx + dir;
                    if (tgt >= 0 && tgt < d.getBoardOrder().size()) {
                        Collections.swap(d.getBoardOrder(), idx, tgt);
                    }
                } else {
                    ScoreField f;
                    boolean on = d.isFieldEnabled(f = d.getBoardOrder().get(idx));
                    d.setFieldEnabled(f, !on);
                    if (f == ScoreField.BALANCE) {
                        d.setShowBalance(!on);
                    }
                }
                this.openScoreboardGui(p);
                this.updateScoreboard(p);
            }
            return;
        }
        if (title.equals("Config")) {
            PlayerData d = this.getData(p.getUniqueId());
            if (slot == 0) {
                d.setScoreboardEnabled(!d.isScoreboardEnabled());
                if (d.isScoreboardEnabled()) {
                    this.updateScoreboard(p);
                } else {
                    p.setScoreboard(this.scoreboardManager.getNewScoreboard());
                }
                this.openConfigGui(p);
            } else if (slot == 1) {
                this.openScoreboardGui(p);
            } else if (slot == 8) {
                this.openMainGui(p);
            }
            return;
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent e) {
        boolean custom;
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        String title = e.getView().getTitle();
        boolean bl = custom = title.startsWith("Level Config") || title.startsWith("Admin Menu") || title.startsWith("Challenge") || title.startsWith("Kill Config") || title.startsWith("Daily") || title.startsWith("Weekly") || title.startsWith("Skills") || title.startsWith("Stats") || title.startsWith("Scoreboard") || title.startsWith("Config");
        if (custom) {
            e.setCancelled(true);
        }
    }

    private void awardXp(Player p, int amt) {
        PlayerData d = this.getData(p.getUniqueId());
        d.addXp(amt);
        if (d.getLevel() < this.levelCap && d.tryLevelUp()) {
            this.msg((CommandSender)p, "Je bent geleveld naar level " + d.getLevel() + "!");
            p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
            this.giveLevelReward(p, d);
        } else if (d.getLevel() >= this.levelCap) {
            int capXp = d.getLevel() * 100;
            d.setXp(Math.min(d.getXp(), capXp));
        }
        this.updateScoreboard(p);
    }

    private void giveLevelReward(Player p, PlayerData d) {
        int lvl = d.getLevel();
        if (lvl % 20 == 0) {
            String matName = this.getConfig().getString("itemRewards." + lvl, this.getConfig().getString("itemReward", "DIAMOND"));
            Material m = Material.matchMaterial((String)matName);
            if (m != null && m != Material.AIR) {
                p.getInventory().addItem(new ItemStack[]{new ItemStack(m)});
            }
        } else if (lvl % 5 != 0) {
            double money = this.getConfig().getDouble("moneyReward", 100.0);
            this.economy.depositPlayer((OfflinePlayer)p, money);
            this.msg((CommandSender)p, "You earned $" + money);
            d.getStats().addMoneyEarned(money);
            this.addProgress(p, d, ChallengeType.MONEY_EARNED, money);
            d.setLastBalance(this.economy.getBalance((OfflinePlayer)p));
        }
    }

    private void addProgress(Player p, PlayerData d, ChallengeType type, double amount) {
        double nxt;
        double goal;
        double prog;
        if (this.activeDaily.contains((Object)type) && (prog = d.getDailyProgress().get((Object)type).doubleValue()) < (goal = this.dailyGoals.get((Object)type).doubleValue())) {
            nxt = Math.min(goal, prog + amount);
            d.getDailyProgress().put(type, nxt);
            if (nxt >= goal) {
                this.checkChallenge(p, d, type, true);
            }
        }
        if (this.activeWeekly.contains((Object)type) && (prog = d.getWeeklyProgress().get((Object)type).doubleValue()) < (goal = this.weeklyGoals.get((Object)type).doubleValue())) {
            nxt = Math.min(goal, prog + amount);
            d.getWeeklyProgress().put(type, nxt);
            if (nxt >= goal) {
                this.checkChallenge(p, d, type, false);
            }
        }
    }

    private void checkChallenge(Player p, PlayerData d, ChallengeType type, boolean daily) {
        double goal;
        double prog = daily ? d.getDailyProgress().get((Object)type) : d.getWeeklyProgress().get((Object)type);
        if (prog >= (goal = (daily ? this.dailyGoals.get((Object)type) : this.weeklyGoals.get((Object)type)).doubleValue())) {
            this.msg((CommandSender)p, (daily ? "Daily" : "Weekly") + " challenge voltooid: " + type.name().toLowerCase());
            this.distributeChallengeReward(p, d, type, daily);
            if (daily) {
                d.getDailyProgress().put(type, goal);
            } else {
                d.getWeeklyProgress().put(type, goal);
            }
        }
    }

    private void distributeChallengeReward(Player p, PlayerData d, ChallengeType type, boolean daily) {
        String path = "challengeRewards." + (daily ? "daily" : "weekly") + ".types." + type.name();
        int xp = this.getConfig().getInt(path + ".xp", this.getConfig().getInt("challengeRewards." + (daily ? "daily" : "weekly") + ".xp", daily ? 20 : 50));
        double money = this.getConfig().getDouble(path + ".money", this.getConfig().getDouble("challengeRewards." + (daily ? "daily" : "weekly") + ".money", 0.0));
        if (xp > 0) {
            this.awardXp(p, xp);
        }
        if (money > 0.0) {
            this.economy.depositPlayer((OfflinePlayer)p, money);
            this.msg((CommandSender)p, "You earned $" + money);
            d.getStats().addMoneyEarned(money);
            d.setLastBalance(this.economy.getBalance((OfflinePlayer)p));
        }
    }

    private void updateScoreboard(Player p) {
        PlayerData d = this.getData(p.getUniqueId());
        if (!d.isScoreboardEnabled()) {
            return;
        }
        Scoreboard board = this.scoreboardManager.getNewScoreboard();
        Objective obj = board.registerNewObjective("levelsx", "dummy", ChatColor.GREEN + "LevelsX");
        obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        Stats s = d.getStats();
        long count = d.getBoardOrder().stream().filter(d::isFieldEnabled).count();
        int line = (int)count;
        int needed = d.getLevel() * 100;
        for (ScoreField f : d.getBoardOrder()) {
            if (!d.isFieldEnabled(f)) continue;
            switch (f) {
                case LEVEL: {
                    obj.getScore(ChatColor.YELLOW + "Level: " + ChatColor.WHITE + d.getLevel()).setScore(line--);
                    break;
                }
                case BALANCE: {
                    double bal = this.economy.getBalance((OfflinePlayer)p);
                    obj.getScore(ChatColor.GOLD + "Balance: " + ChatColor.WHITE + String.format("%.2f", bal)).setScore(line--);
                    break;
                }
                case XP: {
                    obj.getScore(ChatColor.YELLOW + "XP: " + ChatColor.WHITE + d.getXp() + "/" + needed).setScore(line--);
                    break;
                }
                case PROGRESS: {
                    if (d.getLevel() >= this.levelCap) {
                        obj.getScore(ChatColor.AQUA + "MAX LEVEL").setScore(line--);
                        break;
                    }
                    obj.getScore(this.createBar((double)d.getXp() / (double)needed)).setScore(line--);
                    break;
                }
                case KILLS: {
                    obj.getScore(ChatColor.YELLOW + "Kills: " + ChatColor.WHITE + s.getKills()).setScore(line--);
                    break;
                }
                case MOB_KILLS: {
                    obj.getScore(ChatColor.YELLOW + "Mob Kills: " + ChatColor.WHITE + s.getMobKills()).setScore(line--);
                    break;
                }
                case DEATHS: {
                    obj.getScore(ChatColor.YELLOW + "Deaths: " + ChatColor.WHITE + s.getDeaths()).setScore(line--);
                    break;
                }
                case KM: {
                    obj.getScore(ChatColor.YELLOW + "KM: " + ChatColor.WHITE + String.format("%.1f", s.getKilometersTraveled())).setScore(line--);
                }
            }
        }
        p.setScoreboard(board);
    }

    private String createBar(double progress) {
        int filled = (int)Math.round(progress * 10.0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            sb.append(i < filled ? ChatColor.GREEN + "|" : ChatColor.DARK_GRAY + "|");
        }
        return sb.toString();
    }

    private void checkBalances() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            PlayerData d = this.getData(p.getUniqueId());
            double cur = this.economy.getBalance((OfflinePlayer)p);
            double diff = cur - d.getLastBalance();
            if (!(Math.abs(diff) > 0.01)) continue;
            if (diff > 0.0) {
                d.getStats().addMoneyEarned(diff);
                this.addProgress(p, d, ChallengeType.MONEY_EARNED, diff);
            } else {
                diff = -diff;
                d.getStats().addMoneySpent(diff);
                this.addProgress(p, d, ChallengeType.MONEY_SPENT, diff);
            }
            d.setLastBalance(cur);
        }
    }

    private void checkChallengeResets() {
        long now = System.currentTimeMillis();
        if (now - this.lastDailySelect > 86400000L) {
            this.lastDailySelect = now;
            this.selectDailyChallenges();
            this.players.values().forEach(d -> d.setLastDailyReset(now));
        }
        if (now - this.lastWeeklySelect > 604800000L) {
            this.lastWeeklySelect = now;
            this.selectWeeklyChallenges();
            this.players.values().forEach(d -> d.setLastWeeklyReset(now));
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String lbl, String[] args) {
        if (!(sender instanceof Player)) {
            this.msg(sender, "Alleen spelers kunnen dit commando gebruiken");
            return true;
        }
        Player p = (Player)sender;
        if (args.length == 0) {
            this.openMainGui(p);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "help": {
                this.msg((CommandSender)p, "/skill - open menu");
                this.msg((CommandSender)p, "/skill admin - admin menu");
                this.msg((CommandSender)p, "/skill leaderboard <stat>");
                this.msg((CommandSender)p, "/skill stats");
                this.msg((CommandSender)p, "/skill challenges");
                this.msg((CommandSender)p, "/skill spend <amount>");
                this.msg((CommandSender)p, "/skill scoreboard");
                this.msg((CommandSender)p, "/skill backup <sql|sqlite>");
                this.msg((CommandSender)p, "/skill reload");
                this.msg((CommandSender)p, "/skill setlevel <player> <level>");
                this.msg((CommandSender)p, "/skill setskillpoints <player> <amount>");
                break;
            }
            case "admin": {
                if (!p.hasPermission("skill.admin")) {
                    this.msg((CommandSender)p, "Geen permissie");
                    break;
                }
                this.openAdminMenu(p);
                break;
            }
            case "leaderboard": {
                this.showLeaderboard(p, args.length > 1 ? args[1] : "kills");
                break;
            }
            case "stats": {
                this.openStatsGui(p);
                break;
            }
            case "challenges": {
                this.openDailyGui(p);
                break;
            }
            case "spend": {
                if (args.length > 1) {
                    this.doSpend(p, args[1]);
                    break;
                }
                this.msg((CommandSender)p, "Gebruik /skill spend <amount>");
                break;
            }
            case "scoreboard": {
                this.toggleScoreboard(p);
                break;
            }
            case "reload": {
                if (!p.hasPermission("skill.admin")) {
                    this.msg((CommandSender)p, "Geen permissie");
                    break;
                }
                this.reloadPlugin();
                this.msg((CommandSender)p, "Config herladen");
                break;
            }
            case "backup": {
                if (!p.hasPermission("skill.admin")) {
                    this.msg((CommandSender)p, "Geen permissie");
                    break;
                }
                if (args.length > 1) {
                    this.doBackup(p, args[1]);
                    break;
                }
                this.msg((CommandSender)p, "Geef sql of sqlite op");
                break;
            }
            case "setlevel": {
                if (!p.hasPermission("skill.admin")) {
                    this.msg((CommandSender)p, "Geen permissie");
                    break;
                }
                if (args.length < 3) {
                    this.msg((CommandSender)p, "Gebruik /skill setlevel <player> <level>");
                    break;
                }
                Player t = Bukkit.getPlayer((String)args[1]);
                if (t == null) {
                    this.msg((CommandSender)p, "Speler niet online");
                    break;
                }
                try {
                    int lvl = Integer.parseInt(args[2]);
                    PlayerData d = this.getData(t.getUniqueId());
                    d.setLevel(Math.max(1, Math.min(this.levelCap, lvl)));
                    this.updateScoreboard(t);
                    this.msg((CommandSender)p, "Level voor " + t.getName() + " ingesteld op " + lvl);
                }
                catch (NumberFormatException ex) {
                    this.msg((CommandSender)p, "Ongeldig level");
                }
                break;
            }
            case "setskillpoints": {
                if (!p.hasPermission("skill.admin")) {
                    this.msg((CommandSender)p, "Geen permissie");
                    break;
                }
                if (args.length < 3) {
                    this.msg((CommandSender)p, "Gebruik /skill setskillpoints <player> <amount>");
                    break;
                }
                Player t = Bukkit.getPlayer((String)args[1]);
                if (t == null) {
                    this.msg((CommandSender)p, "Speler niet online");
                    break;
                }
                try {
                    int amt = Integer.parseInt(args[2]);
                    this.getData(t.getUniqueId()).setSkillPoints(Math.max(0, amt));
                    this.msg((CommandSender)p, "Skill points voor " + t.getName() + " ingesteld op " + amt);
                }
                catch (NumberFormatException ex) {
                    this.msg((CommandSender)p, "Ongeldige waarde");
                }
                break;
            }
            default: {
                this.msg((CommandSender)p, "Gebruik /skill help voor commando's");
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender s, Command c, String a, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("help", "admin", "leaderboard", "stats", "challenges", "spend", "scoreboard", "backup", "reload", "setlevel", "setskillpoints").stream().filter(x -> x.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("leaderboard")) {
            return Arrays.asList("kills", "mobkills", "deaths", "damage", "distance").stream().filter(x -> x.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("backup")) {
            return Arrays.asList("sql", "sqlite").stream().filter(x -> x.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void doBackup(Player p, String dest) {
        try {
            if (dest.equalsIgnoreCase("sql")) {
                FileConfiguration cfg = this.getConfig();
                MySqlStorage b = new MySqlStorage(cfg.getString("storage.mysql.host", "localhost"), cfg.getInt("storage.mysql.port", 3306), cfg.getString("storage.mysql.database", "levelsx"), cfg.getString("storage.mysql.user", "root"), cfg.getString("storage.mysql.password", ""));
                b.save(this.players);
                b.close();
            } else {
                SqliteStorage b = new SqliteStorage(new File(this.getDataFolder(), "backup"));
                b.save(this.players);
                b.close();
            }
            this.msg((CommandSender)p, "Backup voltooid");
        }
        catch (Exception e) {
            this.msg((CommandSender)p, "Backup mislukt: " + e.getMessage());
        }
    }

    private void doSpend(Player p, String arg) {
        try {
            double amt = Double.parseDouble(arg);
            PlayerData d = this.getData(p.getUniqueId());
            d.getStats().addMoneySpent(amt);
            this.addProgress(p, d, ChallengeType.MONEY_SPENT, amt);
            this.economy.withdrawPlayer((OfflinePlayer)p, amt);
            this.msg((CommandSender)p, "You spent $" + amt);
            d.setLastBalance(this.economy.getBalance((OfflinePlayer)p));
            int xp = (int)(amt / 100.0);
            if (xp > 0) {
                this.awardXp(p, xp);
            }
        }
        catch (NumberFormatException e) {
            this.msg((CommandSender)p, "Ongeldige hoeveelheid");
        }
    }

    private void loadData() {
        try {
            if (this.storage != null) {
                this.storage.load(this.players);
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Load failed: " + e.getMessage());
        }
    }

    private void saveData() {
        try {
            if (this.storage != null) {
                this.storage.save(this.players);
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Save failed: " + e.getMessage());
        }
    }

    private void msg(CommandSender t, String m) {
        t.sendMessage(ChatColor.GOLD + "[LevelsX] " + ChatColor.RESET + m);
    }

    private ItemStack createItem(Material mat, String name, String ... lore) {
        ItemStack it = new ItemStack(mat);
        ItemMeta im = it.getItemMeta();
        im.setDisplayName(name);
        if (lore.length > 0) {
            im.setLore(Arrays.asList(lore));
        }
        it.setItemMeta(im);
        return it;
    }

    private void openMainGui(Player p) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)p, (int)9, (String)"Menu");
        inv.setItem(0, this.createItem(Material.ENCHANTED_BOOK, "Skills", new String[0]));
        inv.setItem(1, this.createItem(Material.PAPER, "Daily", new String[0]));
        inv.setItem(2, this.createItem(Material.MAP, "Weekly", new String[0]));
        inv.setItem(3, this.createItem(Material.BOOK, "Stats", new String[0]));
        inv.setItem(4, this.createItem(Material.COMPARATOR, "Config", new String[0]));
        p.openInventory(inv);
    }

    private void openSkillGui(Player p) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)p, (int)9, (String)"Skills");
        PlayerData d = this.getData(p.getUniqueId());
        int i = 0;
        for (Skill s : Skill.values()) {
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("Level " + d.getSkillLevel(s));
            lore.add(this.getSkillInfo(s, d.getSkillLevel(s)));
            lore.add("Max 10");
            inv.setItem(i++, this.createItem(Material.BOOK, s.name(), lore.toArray(new String[0])));
        }
        inv.setItem(7, this.createItem(Material.ARROW, "Back", new String[0]));
        inv.setItem(8, this.createItem(Material.EXPERIENCE_BOTTLE, "Skill Points: " + d.getSkillPoints(), new String[0]));
        p.openInventory(inv);
    }

    private void openDailyGui(Player p) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)p, (int)18, (String)"Daily");
        PlayerData d = this.getData(p.getUniqueId());
        int i = 0;
        for (ChallengeType t : this.activeDaily) {
            double prog = d.getDailyProgress().get((Object)t);
            double goal = this.dailyGoals.get((Object)t);
            int xp = this.getConfig().getInt("challengeRewards.daily.types." + t.name() + ".xp", this.getConfig().getInt("challengeRewards.daily.xp", 20));
            double money = this.getConfig().getDouble("challengeRewards.daily.types." + t.name() + ".money", this.getConfig().getDouble("challengeRewards.daily.money", 0.0));
            inv.setItem(i++, this.createItem(Material.PAPER, t.name(), String.format("%.1f/%.1f", prog, goal), "Reward: " + xp + " XP, $" + money));
        }
        inv.setItem(17, this.createItem(Material.ARROW, "Back", new String[0]));
        p.openInventory(inv);
    }

    private void openWeeklyGui(Player p) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)p, (int)18, (String)"Weekly");
        PlayerData d = this.getData(p.getUniqueId());
        int i = 0;
        for (ChallengeType t : this.activeWeekly) {
            double prog = d.getWeeklyProgress().get((Object)t);
            double goal = this.weeklyGoals.get((Object)t);
            int xp = this.getConfig().getInt("challengeRewards.weekly.types." + t.name() + ".xp", this.getConfig().getInt("challengeRewards.weekly.xp", 50));
            double money = this.getConfig().getDouble("challengeRewards.weekly.types." + t.name() + ".money", this.getConfig().getDouble("challengeRewards.weekly.money", 0.0));
            inv.setItem(i++, this.createItem(Material.MAP, t.name(), String.format("%.1f/%.1f", prog, goal), "Reward: " + xp + " XP, $" + money));
        }
        inv.setItem(17, this.createItem(Material.ARROW, "Back", new String[0]));
        p.openInventory(inv);
    }

    private void openStatsGui(Player p) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)p, (int)27, (String)"Stats");
        PlayerData d = this.getData(p.getUniqueId());
        Stats s = d.getStats();
        inv.setItem(0, this.createItem(Material.EXPERIENCE_BOTTLE, "Level " + d.getLevel(), "XP: " + d.getXp(), "Skill points: " + d.getSkillPoints()));
        inv.setItem(1, this.createItem(Material.IRON_SWORD, "Kills", String.valueOf(s.getKills())));
        inv.setItem(2, this.createItem(Material.ZOMBIE_HEAD, "Mob Kills", String.valueOf(s.getMobKills())));
        inv.setItem(3, this.createItem(Material.SKELETON_SKULL, "Deaths", String.valueOf(s.getDeaths())));
        inv.setItem(4, this.createItem(Material.DIAMOND_SWORD, "Damage Dealt", String.format("%.1f", s.getDamageDealt())));
        inv.setItem(5, this.createItem(Material.SHIELD, "Damage Taken", String.format("%.1f", s.getDamageTaken())));
        inv.setItem(6, this.createItem(Material.EMERALD, "Money Earned", String.format("%.2f", s.getMoneyEarned())));
        inv.setItem(7, this.createItem(Material.GOLD_INGOT, "Money Spent", String.format("%.2f", s.getMoneySpent())));
        inv.setItem(8, this.createItem(Material.COMPASS, "Kilometers Traveled", String.format("%.2f", s.getKilometersTraveled())));
        inv.setItem(9, this.createItem(Material.CLOCK, "Time Online", this.formatTime(s.getTimeOnline())));
        inv.setItem(26, this.createItem(Material.ARROW, "Back", new String[0]));
        p.openInventory(inv);
    }

    private void openConfigGui(Player p) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)p, (int)9, (String)"Config");
        PlayerData d = this.getData(p.getUniqueId());
        inv.setItem(0, this.createItem(Material.COMPARATOR, "Scoreboard", d.isScoreboardEnabled() ? "ON" : "OFF"));
        inv.setItem(1, this.createItem(Material.PAPER, "Scoreboard Settings", new String[0]));
        inv.setItem(8, this.createItem(Material.ARROW, "Back", new String[0]));
        p.openInventory(inv);
    }

    private void openScoreboardGui(Player p) {
        PlayerData d = this.getData(p.getUniqueId());
        int size = ((ScoreField.values().length + 1) / 9 + 1) * 9;
        Inventory inv = Bukkit.createInventory((InventoryHolder)p, (int)size, (String)"Scoreboard");
        int slot = 0;
        for (ScoreField f : d.getBoardOrder()) {
            Material m = d.isFieldEnabled(f) ? Material.LIME_WOOL : Material.RED_WOOL;
            inv.setItem(slot++, this.createItem(m, f.getLabel(), "Left: toggle", "Shift+Left/Right: move"));
        }
        inv.setItem(size - 1, this.createItem(Material.ARROW, "Back", new String[0]));
        p.openInventory(inv);
    }

    private void openAdminMenu(Player p) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)p, (int)9, (String)"Admin Menu");
        inv.setItem(0, this.createItem(Material.EXPERIENCE_BOTTLE, "Level Config", new String[0]));
        inv.setItem(1, this.createItem(Material.PAPER, "Challenge Config", new String[0]));
        inv.setItem(2, this.createItem(Material.DIAMOND_SWORD, "Kill Config", new String[0]));
        inv.setItem(8, this.createItem(Material.BARRIER, "Close", new String[0]));
        p.openInventory(inv);
    }

    private void openLevelConfigGui(Player p) {
        Material m;
        int rewardSlots = this.levelCap / 20;
        int extra = 4;
        int moneySlot = (rewardSlots + extra + 8) / 9 * 9 - extra;
        int itemSlot = moneySlot + 1;
        int capSlot = moneySlot + 2;
        int backSlot = moneySlot + 3;
        int size = backSlot + 1;
        Inventory inv = Bukkit.createInventory((InventoryHolder)p, (int)size, (String)"Level Config");
        for (int i = 0; i < rewardSlots; ++i) {
            int lvl = (i + 1) * 20;
            String matName = this.getConfig().getString("itemRewards." + lvl, this.getConfig().getString("itemReward", "DIAMOND"));
            m = Material.matchMaterial((String)matName);
            if (m == null) {
                m = Material.BARRIER;
            }
            inv.setItem(i, this.createItem(m, "Level " + lvl, new String[0]));
        }
        double money = this.getConfig().getDouble("moneyReward", 100.0);
        inv.setItem(moneySlot, this.createItem(Material.EMERALD, "Money Reward", "$" + money));
        String defItem = this.getConfig().getString("itemReward", "DIAMOND");
        m = Material.matchMaterial((String)defItem);
        if (m == null) {
            m = Material.BARRIER;
        }
        inv.setItem(itemSlot, this.createItem(m, "Default Item", new String[0]));
        inv.setItem(capSlot, this.createItem(Material.BEDROCK, "Level Cap", String.valueOf(this.levelCap)));
        inv.setItem(backSlot, this.createItem(Material.ARROW, "Back", new String[0]));
        p.openInventory(inv);
    }

    private void openChallengeConfigGui(Player p) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)p, (int)9, (String)"Challenge Config");
        int i = 0;
        for (ChallengeType t : ChallengeType.values()) {
            inv.setItem(i++, this.createItem(Material.PAPER, t.name(), new String[0]));
        }
        inv.setItem(8, this.createItem(Material.ARROW, "Back", new String[0]));
        p.openInventory(inv);
    }

    private void openChallengeTypeGui(Player p, ChallengeType t) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)p, (int)9, (String)("Challenge " + t.name()));
        String base = "challengeRewards.";
        int dxp = this.getConfig().getInt(base + "daily.types." + t.name() + ".xp", this.getConfig().getInt(base + "daily.xp", 20));
        double dmoney = this.getConfig().getDouble(base + "daily.types." + t.name() + ".money", this.getConfig().getDouble(base + "daily.money", 0.0));
        int wxp = this.getConfig().getInt(base + "weekly.types." + t.name() + ".xp", this.getConfig().getInt(base + "weekly.xp", 50));
        double wmoney = this.getConfig().getDouble(base + "weekly.types." + t.name() + ".money", this.getConfig().getDouble(base + "weekly.money", 0.0));
        double dgoal = this.getConfig().getDouble("dailyGoals." + t.name(), this.getDefaultGoal(t));
        double wgoal = this.getConfig().getDouble("weeklyGoals." + t.name(), this.getDefaultGoal(t) * 5.0);
        inv.setItem(0, this.createItem(Material.EXPERIENCE_BOTTLE, "Daily XP", String.valueOf(dxp)));
        inv.setItem(1, this.createItem(Material.EMERALD, "Daily Money", "$" + dmoney));
        inv.setItem(2, this.createItem(Material.TARGET, "Daily Goal", String.valueOf(dgoal)));
        inv.setItem(3, this.createItem(Material.EXPERIENCE_BOTTLE, "Weekly XP", String.valueOf(wxp)));
        inv.setItem(4, this.createItem(Material.EMERALD, "Weekly Money", "$" + wmoney));
        inv.setItem(5, this.createItem(Material.TARGET, "Weekly Goal", String.valueOf(wgoal)));
        inv.setItem(8, this.createItem(Material.ARROW, "Back", new String[0]));
        p.openInventory(inv);
    }

    private void openKillConfigGui(Player p) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)p, (int)9, (String)"Kill Config");
        int pxp = this.getConfig().getInt("killRewards.players.xp", 25);
        double pmoney = this.getConfig().getDouble("killRewards.players.money", 0.0);
        int mxp = this.getConfig().getInt("killRewards.mobs.xp", 10);
        double mmoney = this.getConfig().getDouble("killRewards.mobs.money", 0.0);
        inv.setItem(0, this.createItem(Material.EXPERIENCE_BOTTLE, "Player XP", String.valueOf(pxp)));
        inv.setItem(1, this.createItem(Material.EMERALD, "Player Money", "$" + pmoney));
        inv.setItem(3, this.createItem(Material.EXPERIENCE_BOTTLE, "Mob XP", String.valueOf(mxp)));
        inv.setItem(4, this.createItem(Material.EMERALD, "Mob Money", "$" + mmoney));
        inv.setItem(8, this.createItem(Material.ARROW, "Back", new String[0]));
        p.openInventory(inv);
    }

    private void toggleScoreboard(Player p) {
        PlayerData d = this.getData(p.getUniqueId());
        boolean on = !d.isScoreboardEnabled();
        d.setScoreboardEnabled(on);
        if (on) {
            this.updateScoreboard(p);
        } else {
            p.setScoreboard(this.scoreboardManager.getNewScoreboard());
        }
        this.msg((CommandSender)p, "Scoreboard " + (on ? "aan" : "uit"));
    }

    private void showLeaderboard(Player p, String stat) {
        Comparator<Map.Entry> comp;
        ArrayList<Map.Entry<UUID, PlayerData>> list = new ArrayList<Map.Entry<UUID, PlayerData>>(this.players.entrySet());
        switch (stat.toLowerCase()) {
            case "kills": {
                comp = Comparator.comparingInt(e -> ((PlayerData)e.getValue()).getStats().getKills());
                break;
            }
            case "mobkills": {
                comp = Comparator.comparingInt(e -> ((PlayerData)e.getValue()).getStats().getMobKills());
                break;
            }
            case "deaths": {
                comp = Comparator.comparingInt(e -> ((PlayerData)e.getValue()).getStats().getDeaths());
                break;
            }
            case "damage": {
                comp = Comparator.comparingDouble(e -> ((PlayerData)e.getValue()).getStats().getDamageDealt());
                break;
            }
            case "distance": {
                comp = Comparator.comparingDouble(e -> ((PlayerData)e.getValue()).getStats().getKilometersTraveled());
                break;
            }
            default: {
                this.msg((CommandSender)p, "Onbekende statistiek");
                return;
            }
        }
        list.sort(comp.reversed());
        this.msg((CommandSender)p, "Leaderboard voor " + stat.toLowerCase() + ":");
        int max = Math.min(10, list.size());
        for (int i = 0; i < max; ++i) {
            double val;
            Map.Entry e2 = (Map.Entry)list.get(i);
            String name = Bukkit.getOfflinePlayer((UUID)((UUID)e2.getKey())).getName();
            Stats s = ((PlayerData)e2.getValue()).getStats();
            switch (stat.toLowerCase()) {
                case "kills": {
                    val = s.getKills();
                    break;
                }
                case "mobkills": {
                    val = s.getMobKills();
                    break;
                }
                case "deaths": {
                    val = s.getDeaths();
                    break;
                }
                case "damage": {
                    val = s.getDamageDealt();
                    break;
                }
                default: {
                    val = s.getKilometersTraveled();
                }
            }
            String formatted = stat.equalsIgnoreCase("kills") || stat.equalsIgnoreCase("mobkills") || stat.equalsIgnoreCase("deaths") ? String.valueOf((int)val) : String.format("%.1f", val);
            this.msg((CommandSender)p, i + 1 + ". " + name + ": " + formatted);
        }
    }

    private void updateLungCapacity(Player p, PlayerData d) {
        int lvl = d.getSkillLevel(Skill.LUNG_CAPACITY);
        int base = 300;
        p.setMaximumAir(base + lvl * 20);
        if (p.getRemainingAir() < base + lvl * 20) {
            p.setRemainingAir(base + lvl * 20);
        }
    }

    private void applyHealing(Player p, PlayerData d) {
        int lvl = d.getSkillLevel(Skill.HEALING);
        if (lvl > 0) {
            double heal = (double)lvl * 2.0;
            p.setHealth(Math.min(p.getMaxHealth(), p.getHealth() + heal));
        }
    }

    private String formatTime(long ms) {
        long totMin = ms / 60000L;
        long days = totMin / 1440L;
        long hrs = totMin % 1440L / 60L;
        long mins = totMin % 60L;
        return String.format("%02d:%02d:%02d", days, hrs, mins);
    }

    private String getSkillInfo(Skill s, int lvl) {
        switch (s) {
            case DAMAGE: {
                return "Damage +" + lvl * 5 + "%";
            }
            case DAMAGE_REDUCTION: {
                return "Damage taken -" + lvl * 5 + "%";
            }
            case HEALING: {
                return "Heal " + lvl + " hearts";
            }
            case LIFESTEAL: {
                return "Lifesteal " + lvl * 5 + "%";
            }
            case LUNG_CAPACITY: {
                return "+" + lvl + "s underwater";
            }
        }
        return "";
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    private void setupStorage() {
        FileConfiguration cfg = this.getConfig();
        String type = cfg.getString("storage.type", "sqlite");
        try {
            this.storage = "mysql".equalsIgnoreCase(type) ? new MySqlStorage(cfg.getString("storage.mysql.host", "localhost"), cfg.getInt("storage.mysql.port", 3306), cfg.getString("storage.mysql.database", "levelsx"), cfg.getString("storage.mysql.user", "root"), cfg.getString("storage.mysql.password", "")) : new SqliteStorage(this.getDataFolder());
        }
        catch (Exception e) {
            this.getLogger().severe("Storage init failed: " + e.getMessage());
        }
    }

    private void reloadPlugin() {
        this.reloadConfig();
        this.levelCap = Math.min(1000, Math.max(1, this.getConfig().getInt("levelCap", 100)));
        this.initChallenges();
        if (this.autosaveTask != -1) {
            Bukkit.getScheduler().cancelTask(this.autosaveTask);
        }
        int minutes = Math.max(1, this.getConfig().getInt("autosave", 5));
        this.autosaveTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this::saveData, 1200L * (long)minutes, 1200L * (long)minutes);
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.updateScoreboard(p);
        }
    }
}

