/*
 * Decompiled with CFR 0.152.
 */
package com.alphactx.storage;

import com.alphactx.model.ChallengeType;
import com.alphactx.model.PlayerData;
import com.alphactx.model.ScoreField;
import com.alphactx.model.Skill;
import com.alphactx.model.Stats;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.FileConfiguration;

public final class DataUtil {
    private DataUtil() {
    }

    public static void load(FileConfiguration cfg, PlayerData data) {
        data.setXp(cfg.getInt("xp", 0));
        data.setLevel(cfg.getInt("level", 1));
        data.addSkillPoints(cfg.getInt("skillPoints", 0));
        for (Skill s : Skill.values()) {
            data.setSkillLevel(s, cfg.getInt("skills." + s.name(), 0));
        }
        Stats stats = data.getStats();
        stats.addKill(cfg.getInt("stats.kills", 0));
        stats.addMobKill(cfg.getInt("stats.mobKills", 0));
        stats.addDeath(cfg.getInt("stats.deaths", 0));
        stats.addDamageDealt(cfg.getDouble("stats.damageDealt", 0.0));
        stats.addDamageTaken(cfg.getDouble("stats.damageTaken", 0.0));
        stats.addMoneyEarned(cfg.getDouble("stats.moneyEarned", 0.0));
        stats.addMoneySpent(cfg.getDouble("stats.moneySpent", 0.0));
        stats.addKilometersTraveled(cfg.getDouble("stats.km", 0.0));
        stats.setTimeOnline(cfg.getLong("stats.time", 0L));
        data.setLastBalance(cfg.getDouble("lastBalance", 0.0));
        data.setScoreboardEnabled(cfg.getBoolean("scoreboardEnabled", false));
        data.setShowBalance(cfg.getBoolean("showBalance", false));
        List order = cfg.getStringList("board.order");
        if (order.isEmpty()) {
            order = Arrays.stream(ScoreField.values()).map(Enum::name).collect(Collectors.toList());
        }
        data.getBoardOrder().clear();
        for (String name : order) {
            try {
                data.getBoardOrder().add(ScoreField.valueOf(name));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        for (ScoreField scoreField : ScoreField.values()) {
            boolean def = scoreField == ScoreField.LEVEL || scoreField == ScoreField.XP || scoreField == ScoreField.PROGRESS || scoreField == ScoreField.BALANCE && data.isShowBalance();
            data.setFieldEnabled(scoreField, cfg.getBoolean("board.enabled." + scoreField.name(), def));
        }
        data.loadLastDailyReset(cfg.getLong("lastDailyReset", System.currentTimeMillis()));
        data.loadLastWeeklyReset(cfg.getLong("lastWeeklyReset", System.currentTimeMillis()));
        for (Enum enum_ : ChallengeType.values()) {
            data.addDailyProgress((ChallengeType)enum_, cfg.getDouble("daily." + enum_.name(), 0.0));
            data.addWeeklyProgress((ChallengeType)enum_, cfg.getDouble("weekly." + enum_.name(), 0.0));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void save(FileConfiguration cfg, PlayerData data) {
        void var4_6;
        cfg.set("xp", (Object)data.getXp());
        cfg.set("level", (Object)data.getLevel());
        cfg.set("skillPoints", (Object)data.getSkillPoints());
        Skill[] skillArray = Skill.values();
        int n = skillArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            Skill s = skillArray[var4_6];
            cfg.set("skills." + s.name(), (Object)data.getSkillLevel(s));
            ++var4_6;
        }
        Stats stats = data.getStats();
        cfg.set("stats.kills", (Object)stats.getKills());
        cfg.set("stats.mobKills", (Object)stats.getMobKills());
        cfg.set("stats.deaths", (Object)stats.getDeaths());
        cfg.set("stats.damageDealt", (Object)stats.getDamageDealt());
        cfg.set("stats.damageTaken", (Object)stats.getDamageTaken());
        cfg.set("stats.moneyEarned", (Object)stats.getMoneyEarned());
        cfg.set("stats.moneySpent", (Object)stats.getMoneySpent());
        cfg.set("stats.km", (Object)stats.getKilometersTraveled());
        cfg.set("stats.time", (Object)stats.getTimeOnline());
        cfg.set("lastBalance", (Object)data.getLastBalance());
        cfg.set("scoreboardEnabled", (Object)data.isScoreboardEnabled());
        cfg.set("showBalance", (Object)data.isShowBalance());
        cfg.set("board.order", data.getBoardOrder().stream().map(Enum::name).collect(Collectors.toList()));
        for (ScoreField f : ScoreField.values()) {
            cfg.set("board.enabled." + f.name(), (Object)data.isFieldEnabled(f));
        }
        cfg.set("lastDailyReset", (Object)data.getLastDailyReset());
        cfg.set("lastWeeklyReset", (Object)data.getLastWeeklyReset());
        for (Map.Entry entry : data.getDailyProgress().entrySet()) {
            cfg.set("daily." + ((ChallengeType)((Object)entry.getKey())).name(), entry.getValue());
        }
        for (Map.Entry entry : data.getWeeklyProgress().entrySet()) {
            cfg.set("weekly." + ((ChallengeType)((Object)entry.getKey())).name(), entry.getValue());
        }
    }
}

